"use strict";
/*********************************************************************
 * Copyright (c) 2020 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 **********************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
const commandExists = require("command-exists");
exports.KUBERNETES_CLI = 'kubectl';
exports.OPENSHIFT_CLI = 'oc';
function getClusterClientCommand() {
    const clusterClients = [exports.KUBERNETES_CLI, exports.OPENSHIFT_CLI];
    for (const command of clusterClients) {
        if (commandExists.sync(command)) {
            return command;
        }
    }
    throw new Error('No cluster CLI client is installed.');
}
exports.getClusterClientCommand = getClusterClientCommand;
//# sourceMappingURL=util.js.map