/*********************************************************************
 * Copyright (c) 2019 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 **********************************************************************/
import { Context } from '@kubernetes/client-node/dist/config_types';
import { Command } from '@oclif/command';
import * as Listr from 'listr';
export default class Inject extends Command {
    static description: string;
    static flags: {
        help: import("@oclif/parser/lib/flags").IBooleanFlag<void>;
        kubeconfig: import("@oclif/parser/lib/flags").IBooleanFlag<boolean>;
        workspace: import("@oclif/parser/lib/flags").IOptionFlag<string | undefined>;
        container: import("@oclif/parser/lib/flags").IOptionFlag<string | undefined>;
        'kube-context': import("@oclif/parser/lib/flags").IOptionFlag<string | undefined>;
        chenamespace: import("@oclif/parser/lib/flags").IOptionFlag<string>;
        'listr-renderer': import("@oclif/parser/lib/flags").IOptionFlag<string>;
    };
    private readonly command;
    run(): Promise<void>;
    injectKubeconfigTasks(flags: any): Promise<Listr>;
    /**
     * Tests whether a file can be injected into the specified container.
     */
    canInject(namespace: string, pod: string, container: string): Promise<boolean>;
    /**
     * Copies the local kubeconfig into the specified container.
     * If returns, it means injection was completed successfully. If throws an error, injection failed
     */
    injectKubeconfig(cheNamespace: string, workspacePod: string, container: string, contextToInject: Context): Promise<void>;
    private fileExists;
    private containerExists;
}
