/**
 * Copyright (c) 2019-2021 Red Hat, Inc.
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *   Red Hat, Inc. - initial API and implementation
 */
/// <reference types="node" />
import { ExtensionsV1beta1IngressList, KubeConfig, V1ClusterRole, V1ClusterRoleBinding, V1ClusterRoleBindingList, V1ConfigMap, V1ContainerStateTerminated, V1ContainerStateWaiting, V1Deployment, V1DeploymentList, V1Job, V1MutatingWebhookConfiguration, V1Namespace, V1NamespaceList, V1PersistentVolumeClaimList, V1Pod, V1PodCondition, V1PodList, V1Role, V1RoleBinding, V1RoleBindingList, V1RoleList, V1Secret, V1Service, V1ServiceAccount, V1ServiceList } from '@kubernetes/client-node';
import { Cluster, Context } from '@kubernetes/client-node/dist/config_types';
import { V1CheClusterBackup } from './typings/backup-restore-crds';
import { V1Certificate } from './typings/cert-manager';
import { CatalogSource, ClusterServiceVersion, ClusterServiceVersionList, InstallPlan, PackageManifest, Subscription } from './typings/olm';
import { IdentityProvider } from './typings/openshift';
export declare class KubeHelper {
    readonly kubeConfig: KubeConfig;
    readonly API_EXTENSIONS_V1BETA1 = "apiextensions.k8s.io/v1beta1";
    podWaitTimeout: number;
    podDownloadImageTimeout: number;
    podReadyTimeout: number;
    podErrorRecheckTimeout: number;
    constructor(flags?: any);
    createNamespace(namespaceName: string, labels: any): Promise<void>;
    deleteAllServices(namespace: string): Promise<void>;
    applyResource(yamlPath: string, opts?: string): Promise<void>;
    getServicesBySelector(labelSelector?: string, namespace?: string): Promise<V1ServiceList>;
    waitForService(selector: string, namespace?: string, intervalMs?: number, timeoutMs?: number): Promise<void>;
    serviceAccountExist(name?: string, namespace?: string): Promise<boolean>;
    createServiceAccount(name?: string, namespace?: string): Promise<{
        response: import("http").IncomingMessage;
        body: V1ServiceAccount;
    }>;
    waitServiceAccount(name: string, namespace: string, timeout?: number): Promise<void>;
    deleteServiceAccount(name: string, namespace: string): Promise<void>;
    createServiceAccountFromFile(filePath: string, namespace?: string): Promise<{
        response: import("http").IncomingMessage;
        body: V1ServiceAccount;
    }>;
    replaceServiceAccountFromFile(filePath: string, namespace?: string): Promise<{
        response: import("http").IncomingMessage;
        body: V1ServiceAccount;
    }>;
    roleExist(name?: string, namespace?: string): Promise<boolean>;
    clusterRoleExist(name?: string): Promise<boolean>;
    getClusterRole(name: string): Promise<V1ClusterRole | undefined>;
    getRole(name: string, namespace: string): Promise<V1Role | undefined>;
    listRoles(namespace: string): Promise<V1RoleList>;
    createRoleFrom(yamlRole: V1Role, namespace: string): Promise<number | undefined>;
    createRoleFromFile(filePath: string, namespace: string): Promise<number | undefined>;
    replaceRoleFrom(yamlRole: V1Role, namespace: string): Promise<number | undefined>;
    replaceRoleFromFile(filePath: string, namespace: string): Promise<number | undefined>;
    listClusterRoles(): Promise<V1RoleList>;
    createClusterRoleFrom(yamlClusterRole: V1ClusterRole, clusterRoleName?: string): Promise<number | undefined>;
    createClusterRoleFromFile(filePath: string, clusterRoleName?: string): Promise<number | undefined>;
    replaceClusterRoleFrom(yamlClusterRole: V1ClusterRole, clusterRoleName?: string): Promise<number | undefined>;
    replaceClusterRoleFromFile(filePath: string, clusterRoleName?: string): Promise<number | undefined>;
    addClusterRoleRule(name: string, apiGroups: string[], resources: string[], verbs: string[]): Promise<V1ClusterRole | undefined>;
    deleteRole(name: string, namespace: string): Promise<void>;
    getPodListByLabel(namespace: string, labelSelector: string): Promise<V1Pod[]>;
    deleteClusterRole(name: string): Promise<void>;
    listRoleBindings(namespace: string): Promise<V1RoleBindingList>;
    roleBindingExist(name?: string, namespace?: string): Promise<boolean>;
    isMutatingWebhookConfigurationExists(name: string): Promise<boolean>;
    getMutatingWebhookConfiguration(name: string): Promise<V1MutatingWebhookConfiguration>;
    isValidatingWebhookConfigurationExists(name: string): Promise<boolean>;
    deleteValidatingWebhookConfiguration(name: string): Promise<void>;
    deleteMutatingWebhookConfiguration(name: string): Promise<void>;
    listClusterRoleBindings(labelSelector?: string, fieldSelector?: string): Promise<V1ClusterRoleBindingList>;
    clusterRoleBindingExist(name: string): Promise<boolean>;
    createAdminRoleBinding(name?: string, serviceAccount?: string, namespace?: string): Promise<{
        response: import("http").IncomingMessage;
        body: V1RoleBinding;
    }>;
    createRoleBindingFrom(yamlRoleBinding: V1RoleBinding, namespace: string): Promise<V1RoleBinding>;
    createRoleBindingFromFile(filePath: string, namespace: string): Promise<V1RoleBinding>;
    replaceRoleBindingFrom(yamlRoleBinding: V1RoleBinding, namespace: string): Promise<V1RoleBinding>;
    replaceRoleBindingFromFile(filePath: string, namespace: string): Promise<V1RoleBinding>;
    createClusterRoleBindingFrom(yamlClusterRoleBinding: V1ClusterRoleBinding): Promise<{
        response: import("http").IncomingMessage;
        body: V1ClusterRoleBinding;
    }>;
    createClusterRoleBinding(name: string, saName: string, saNamespace?: string, roleName?: string): Promise<{
        response: import("http").IncomingMessage;
        body: V1ClusterRoleBinding;
    }>;
    replaceClusterRoleBindingFrom(clusterRoleBinding: V1ClusterRoleBinding): Promise<{
        response: import("http").IncomingMessage;
        body: V1ClusterRoleBinding;
    }>;
    replaceClusterRoleBinding(name: string, saName: string, saNamespace?: string, roleName?: string): Promise<{
        response: import("http").IncomingMessage;
        body: V1ClusterRoleBinding;
    }>;
    deleteRoleBinding(name: string, namespace: string): Promise<void>;
    deleteClusterRoleBinding(name: string): Promise<void>;
    getConfigMap(name?: string, namespace?: string): Promise<V1ConfigMap | undefined>;
    getConfigMapValue(name: string, namespace: string, key: string): Promise<string | undefined>;
    createConfigMapFromFile(filePath: string, namespace?: string): Promise<V1ConfigMap>;
    createNamespacedConfigMap(namespace: string, configMap: V1ConfigMap): Promise<V1ConfigMap>;
    patchConfigMap(name: string, patch: any, namespace?: string): Promise<{
        response: import("http").IncomingMessage;
        body: V1ConfigMap;
    }>;
    deleteConfigMap(name: string, namespace: string): Promise<void>;
    replaceNamespacedConfigMap(name: string, namespace: string, configMap: V1ConfigMap): Promise<V1ConfigMap>;
    getNamespace(namespace: string): Promise<V1Namespace | undefined>;
    hasReadPermissionsForNamespace(namespace: string): Promise<boolean>;
    readNamespacedPod(podName: string, namespace: string): Promise<V1Pod | undefined>;
    patchCustomResource(name: string, namespace: string, patch: any, resourceAPIGroup: string, resourceAPIVersion: string, resourcePlural: string): Promise<any | undefined>;
    patchNamespacedPod(name: string, namespace: string, patch: any): Promise<V1Pod | undefined>;
    podsExistBySelector(selector: string, namespace?: string): Promise<boolean>;
    /**
     * Returns pod waiting state.
     */
    getPodWaitingState(namespace: string, selector: string, desiredPhase: string): Promise<V1ContainerStateWaiting | undefined>;
    /**
     * Returns pod last terminated state.
     */
    getPodLastTerminatedState(namespace: string, selector: string): Promise<V1ContainerStateTerminated | undefined>;
    getPodCondition(namespace: string, selector: string, conditionType: string): Promise<V1PodCondition[]>;
    getPodReadyConditionStatus(selector: string, namespace?: string): Promise<string | undefined>;
    waitForPodReady(selector: string, namespace?: string, intervalMs?: number, timeoutMs?: number): Promise<void>;
    waitUntilPodIsDeleted(selector: string, namespace?: string, intervalMs?: number, timeoutMs?: number): Promise<void>;
    deletePod(name: string, namespace?: string): Promise<{
        response: import("http").IncomingMessage;
        body: V1Pod;
    }>;
    waitLatestReplica(deploymentName: string, namespace?: string, intervalMs?: number, timeoutMs?: number): Promise<void>;
    deploymentExist(name?: string, namespace?: string): Promise<boolean>;
    isConfigMapExists(name: string, namespace: string): Promise<boolean>;
    deploymentReady(name?: string, namespace?: string): Promise<boolean>;
    deploymentStopped(name?: string, namespace?: string): Promise<boolean>;
    isDeploymentPaused(name?: string, namespace?: string): Promise<boolean>;
    pauseDeployment(name?: string, namespace?: string): Promise<void>;
    resumeDeployment(name?: string, namespace?: string): Promise<void>;
    scaleDeployment(name: string | undefined, namespace: string | undefined, replicas: number): Promise<void>;
    createDeployment(name: string, image: string, serviceAccount: string, pullPolicy: string, configMapEnvSource: string, namespace: string): Promise<{
        response: import("http").IncomingMessage;
        body: V1Deployment;
    }>;
    createDeploymentFrom(yamlDeployment: V1Deployment): Promise<void>;
    createServiceFrom(yamlService: V1Service, namespace?: string): Promise<{
        response: import("http").IncomingMessage;
        body: V1Service;
    }>;
    replaceDeploymentFrom(yamlDeployment: V1Deployment): Promise<void>;
    deleteAllDeployments(namespace: string): Promise<void>;
    getDeploymentsBySelector(labelSelector?: string, namespace?: string): Promise<V1DeploymentList>;
    getDeployment(name: string, namespace: string): Promise<V1Deployment | undefined>;
    createPod(name: string, image: string, serviceAccount: string, restartPolicy: string, pullPolicy: string, configMapEnvSource: string, namespace: string): Promise<{
        response: import("http").IncomingMessage;
        body: V1Pod;
    }>;
    createJob(name: string, image: string, serviceAccount: string, namespace: string, backoffLimit?: number, restartPolicy?: string): Promise<{
        response: import("http").IncomingMessage;
        body: V1Job;
    }>;
    getJob(jobName: string, namespace: string): Promise<V1Job>;
    waitJob(jobName: string, namespace: string, timeout?: number): Promise<void>;
    deleteJob(jobName: string, namespace: string): Promise<boolean>;
    compare(body: any, name: string): Promise<boolean>;
    ingressExist(name?: string, namespace?: string): Promise<boolean>;
    deleteAllIngresses(namespace: string): Promise<void>;
    createCrdFromFile(filePath: string): Promise<void>;
    private createCrdV1Beta1;
    private createCrdV1;
    replaceCrdFromFile(filePath: string, resourceVersion: string): Promise<void>;
    private replaceCrdV1Beta1;
    private replaceCrdV1;
    getCrd(name: string): Promise<any | undefined>;
    private getCrdV1;
    private getCrdV1beta1;
    getCrdStorageVersion(name: string): Promise<string>;
    deleteCrd(name: string): Promise<void>;
    private deleteCrdV1Beta1;
    private deleteCrdV1;
    createCheCluster(cheClusterCR: any, flags: any, ctx: any, useDefaultCR: boolean): Promise<any>;
    patchCheCluster(name: string, namespace: string, patch: any): Promise<any>;
    /**
     * Returns `checlusters.org.eclipse.che' in the given namespace.
     */
    getCheCluster(cheNamespace: string): Promise<any | undefined>;
    /**
     * Returns custom resource in the given namespace.
     */
    getCustomResource(namespace: string, resourceAPIGroup: string, resourceAPIVersion: string, resourcePlural: string): Promise<any | undefined>;
    /**
     * Deletes `checlusters.org.eclipse.che' resources in the given namespace.
     */
    getAllCheClusters(): Promise<any[]>;
    /**
     * Returns all custom resources
     */
    getAllCustomResources(resourceAPIGroup: string, resourceAPIVersion: string, resourcePlural: string): Promise<any[]>;
    /**
     * Deletes `checlusters.org.eclipse.che' resources in the given namespace.
     */
    deleteCheCluster(namespace: string): Promise<void>;
    /**
     * Deletes custom resources in the given namespace.
     */
    deleteCustomResource(namespace: string, resourceAPIGroup: string, resourceAPIVersion: string, resourcePlural: string): Promise<void>;
    recreateCheGroupCr(crYaml: any, kindPlural: string): Promise<any>;
    recreateBackupCr(namespace: string, name: string, backupServerConfigName?: string): Promise<V1CheClusterBackup>;
    recreateRestoreCr(namespace: string, name: string, backupServerConfigName?: string, snapshotId?: string): Promise<V1CheClusterBackup>;
    isPreInstalledOLM(): Promise<boolean>;
    getUsersNumber(): Promise<number>;
    getOpenshiftAuthProviders(): Promise<IdentityProvider[]>;
    operatorSourceExists(name: string, namespace: string): Promise<boolean>;
    catalogSourceExists(name: string, namespace: string): Promise<boolean>;
    getOAuthClientAuthorizations(clientName: string): Promise<string[]>;
    deleteOAuthClientAuthorizations(oAuthClientAuthorizations: any[]): Promise<void>;
    consoleLinkExists(name: string): Promise<boolean>;
    deleteConsoleLink(name: string): Promise<void>;
    getCatalogSource(name: string, namespace: string): Promise<CatalogSource>;
    readCatalogSourceFromFile(filePath: string): CatalogSource;
    createCatalogSource(catalogSource: CatalogSource): Promise<object>;
    waitCatalogSource(namespace: string, catalogSourceName: string, timeout?: number): Promise<CatalogSource>;
    deleteCatalogSource(namespace: string, catalogSourceName: string): Promise<void>;
    operatorGroupExists(name: string, namespace: string): Promise<boolean>;
    createOperatorGroup(operatorGroupName: string, namespace: string): Promise<object>;
    deleteOperatorGroup(operatorGroupName: string, namespace: string): Promise<void>;
    createOperatorSubscription(subscription: Subscription): Promise<object>;
    getOperatorSubscription(name: string, namespace: string): Promise<Subscription>;
    operatorSubscriptionExists(name: string, namespace: string): Promise<boolean>;
    deleteOperatorSubscription(operatorSubscriptionName: string, namespace: string): Promise<void>;
    waitOperatorSubscriptionReadyForApproval(namespace: string, subscriptionName: string, timeout?: number): Promise<InstallPlan>;
    approveOperatorInstallationPlan(name?: string, namespace?: string): Promise<void>;
    waitUntilOperatorIsInstalled(installPlanName: string, namespace: string, timeout?: number): Promise<InstallPlan>;
    getCSV(csvName: string, namespace: string): Promise<ClusterServiceVersion | undefined>;
    getClusterServiceVersions(namespace: string): Promise<ClusterServiceVersionList>;
    patchClusterServiceVersion(namespace: string, name: string, jsonPatch: any[]): Promise<ClusterServiceVersion>;
    deleteClusterServiceVersion(namespace: string, csvName: string): Promise<void>;
    getPackageManifect(name: string): Promise<PackageManifest>;
    deleteNamespace(namespace: string): Promise<void>;
    /**
     * Returns CRD version of Cert Manager
     */
    getCertManagerK8sApiVersion(): Promise<string>;
    clusterIssuerExists(name: string, version: string): Promise<boolean>;
    isNamespacedCertificateExists(name: string, version: string, namespace: string): Promise<boolean>;
    deleteNamespacedCertificate(name: string, version: string, namespace: string): Promise<void>;
    deleteNamespacedIssuer(name: string, version: string, namespace: string): Promise<void>;
    listClusterIssuers(version: string, labelSelector?: string): Promise<any[]>;
    createCheClusterIssuer(cheClusterIssuerYamlPath: string, version: string): Promise<void>;
    createCertificateIssuer(cheClusterIssuerYamlPath: string, version: string, namespace: string): Promise<void>;
    isCertificateIssuerExists(name: string, version: string, namespace: string): Promise<boolean>;
    createCheClusterCertificate(certificate: V1Certificate, version: string): Promise<void>;
    currentContext(): Promise<string>;
    getContext(name: string): Context | null;
    /**
     * Retrieve the default token from the default serviceAccount.
     */
    getDefaultServiceAccountToken(): Promise<string>;
    checkKubeApi(): Promise<void>;
    requestKubeHealthz(currentCluster: Cluster, token?: string): Promise<void>;
    isOpenShift(): Promise<boolean>;
    isOpenShift3(): Promise<boolean>;
    isOpenShift4(): Promise<boolean>;
    IsAPIExtensionSupported(version: string): Promise<boolean>;
    IsAPIGroupSupported(name: string, version?: string): Promise<boolean>;
    getIngressHost(name?: string, namespace?: string): Promise<string>;
    getIngressProtocol(name?: string, namespace?: string): Promise<string>;
    getIngressesBySelector(labelSelector?: string, namespace?: string): Promise<ExtensionsV1beta1IngressList>;
    getSecret(name: string, namespace?: string): Promise<V1Secret | undefined>;
    /**
     * Creates a secret with given name and data.
     * Data should not be base64 encoded.
     */
    createSecret(namespace: string, name: string, data: {
        [key: string]: string;
    }): Promise<V1Secret | undefined>;
    /**
     * Deletes specified secret if any.
     */
    deleteSecret(namespace: string, name: string): Promise<void>;
    /**
     * Replaces given secret or creates a new one.
     * Data should not be base64 encoded.
     */
    createOrReplaceSecret(namespace: string, name: string, data: {
        [key: string]: string;
    }): Promise<V1Secret | undefined>;
    /**
     * Awaits secret to be present and contain non-empty data fields specified in dataKeys parameter.
     */
    waitSecret(secretName: string, namespace: string, dataKeys?: string[], timeout?: number): Promise<void>;
    persistentVolumeClaimExist(name?: string, namespace?: string): Promise<boolean>;
    deletePersistentVolumeClaim(name: string, namespace: string): Promise<void>;
    getPersistentVolumeClaimsBySelector(labelSelector?: string, namespace?: string): Promise<V1PersistentVolumeClaimList>;
    listNamespace(): Promise<V1NamespaceList>;
    listNamespacedPod(namespace: string, fieldSelector?: string, labelSelector?: string): Promise<V1PodList>;
    /**
     * Reads log by chunk and writes into a file.
     */
    readNamespacedPodLog(pod: string, namespace: string, container: string, filename: string, follow: boolean): Promise<void>;
    /**
     * Forwards port, based on the example
     * https://github.com/kubernetes-client/javascript/blob/master/examples/typescript/port-forward/port-forward.ts
     */
    portForward(podName: string, namespace: string, port: number): Promise<void>;
    /**
     * Checks if message is present and returns error with it
     * or returns error with the specified error if message is not found.
     *
     * @param e k8s error to wrap
     */
    private wrapK8sClientError;
    safeLoadFromYamlFile(filePath: string): any;
}
