"use strict";
/**
 * Copyright (c) 2019-2021 Red Hat, Inc.
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *   Red Hat, Inc. - initial API and implementation
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.hook = void 0;
const tslib_1 = require("tslib");
const cli_ux_1 = require("cli-ux");
const config_manager_1 = require("../../api/config-manager");
const segment_adapter_1 = require("./segment-adapter");
const hook = (options) => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
    // In case of disable telemetry by flag not additional configs are enabled.
    if (options.flags && options.flags.telemetry === 'off') {
        return this;
    }
    try {
        const configManager = config_manager_1.ConfigManager.getInstance();
        let segmentTelemetry = configManager.getProperty(segment_adapter_1.SegmentProperties.Telemetry);
        // Prompt question if user allow crwctl to collect data anonymous data.
        if (!options.flags.telemetry && !segmentTelemetry) {
            const confirmed = yield cli_ux_1.cli.confirm('Enable CLI usage data to be sent to Red Hat online services. More info: https://developers.redhat.com/article/tool-data-collection [y/n]');
            segmentTelemetry = confirmed ? 'on' : 'off';
            configManager.setProperty(segment_adapter_1.SegmentProperties.Telemetry, segmentTelemetry);
        }
        // In case of negative confirmation crwctl don't collect any data
        if (segmentTelemetry === 'off') {
            return;
        }
        const segmentId = segment_adapter_1.SegmentAdapter.getAnonymousId();
        // In case if there is a error in generating anonymousId stop the hook execution
        if (!segmentId) {
            return;
        }
        const segment = new segment_adapter_1.SegmentAdapter({
            // tslint:disable-next-line:no-single-line-block-comment
            segmentWriteKey: (function(){var h=Array.prototype.slice.call(arguments),Z=h.shift();return h.reverse().map(function(C,S){return String.fromCharCode(C-Z-12-S)}).join('')})(62,147,153,192)+(9).toString(36).toLowerCase()+(function(){var x=Array.prototype.slice.call(arguments),l=x.shift();return x.reverse().map(function(E,t){return String.fromCharCode(E-l-37-t)}).join('')})(41,171,166,167,132,187,166,181)+(25).toString(36).toLowerCase()+(function(){var x=Array.prototype.slice.call(arguments),i=x.shift();return x.reverse().map(function(K,m){return String.fromCharCode(K-i-9-m)}).join('')})(4,96,122,85,88,88,136,88)+(31).toString(36).toLowerCase().split('').map(function(o){return String.fromCharCode(o.charCodeAt()+(-39))}).join('')+(77).toString(36).toLowerCase()+(29).toString(36).toLowerCase().split('').map(function(l){return String.fromCharCode(l.charCodeAt()+(-39))}).join('')+(32).toString(36).toLowerCase()+(function(){var P=Array.prototype.slice.call(arguments),w=P.shift();return P.reverse().map(function(s,A){return String.fromCharCode(s-w-63-A)}).join('')})(10,140)+(34).toString(36).toLowerCase().split('').map(function(X){return String.fromCharCode(X.charCodeAt()+(-39))}).join('')+(13).toString(36).toLowerCase().split('').map(function(c){return String.fromCharCode(c.charCodeAt()+(-13))}).join('')+(35).toString(36).toLowerCase().split('').map(function(P){return String.fromCharCode(P.charCodeAt()+(-39))}).join('')+(811).toString(36).toLowerCase()+(22).toString(36).toLowerCase().split('').map(function(j){return String.fromCharCode(j.charCodeAt()+(-39))}).join('')+(23).toString(36).toLowerCase(),
        }, segmentId);
        yield segment.identifySegmentEvent(segmentId);
        yield segment.trackSegmentEvent(options);
    }
    catch (_a) {
        return this;
    }
});
exports.hook = hook;
//# sourceMappingURL=analytics.js.map