/**
 * Copyright (c) 2019-2021 Red Hat, Inc.
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *   Red Hat, Inc. - initial API and implementation
 */
export declare const CHECTL_PROJECT_NAME = "chectl";
export declare const OPERATOR_TEMPLATE_DIR = "codeready-workspaces-operator";
export declare const MIN_OLM_INSTALLER_VERSION = "7.17.0";
export declare const MIN_CHE_OPERATOR_INSTALLER_VERSION = "7.13.1";
export declare const MIN_HELM_INSTALLER_VERSION = "7.10.0";
export declare const CHE_RELATED_COMPONENT_LABEL = "client/org.eclipse.che=true";
export declare const DEFAULT_CHE_OPERATOR_IMAGE_NAME = "registry.redhat.io/codeready-workspaces/crw-2-rhel8-operator";
export declare const CA_CERT_GENERATION_JOB_IMAGE = "quay.io/eclipse/che-cert-manager-ca-cert-generator:671342c";
export declare const NEXT_TAG = "next";
export declare const CERT_MANAGER_NAMESPACE_NAME = "cert-manager";
export declare const CHE_TLS_SECRET_NAME = "che-tls";
export declare const CHE_ROOT_CA_SECRET_NAME = "self-signed-certificate";
export declare const DEFAULT_CA_CERT_FILE_NAME = "cheCA.crt";
export declare const CHE_CLUSTER_CR_NAME = "codeready-workspaces";
export declare const OPERATOR_DEPLOYMENT_NAME = "codeready-operator";
export declare const CHE_OPERATOR_SELECTOR = "app=codeready-operator";
export declare const DEFAULT_CHE_NAMESPACE = "openshift-workspaces";
export declare const LEGACY_CHE_NAMESPACE = "workspaces";
export declare const DEFAULT_CHE_OLM_PACKAGE_NAME = "codeready-workspaces";
export declare const OLM_STABLE_CHANNEL_NAME = "latest";
export declare const OLM_NIGHTLY_CHANNEL_NAME = "nightly";
export declare const DEFAULT_OPENSHIFT_MARKET_PLACE_NAMESPACE = "openshift-marketplace";
export declare const DEFAULT_OLM_KUBERNETES_NAMESPACE = "olm";
export declare const CUSTOM_CATALOG_SOURCE_NAME = "codeready-custom-catalog-source";
export declare const SUBSCRIPTION_NAME = "codeready-subscription";
export declare const OPERATOR_GROUP_NAME = "codeready-operator-group";
export declare const KUBERNETES_OLM_CATALOG = "operatorhubio-catalog";
export declare const OPENSHIFT_OLM_CATALOG = "redhat-operators";
export declare const CVS_PREFIX = "crwoperator";
export declare const NIGHTLY_CATALOG_SOURCE_NAME = "eclipse-che-preview";
export declare const DEFAULT_OLM_SUGGESTED_NAMESPACE = "openshift-workspaces";
export declare const DOC_LINK = "https://access.redhat.com/documentation/en-us/red_hat_codeready_workspaces/2.11/";
export declare const DOC_LINK_RELEASE_NOTES = "https://access.redhat.com/documentation/en-us/red_hat_codeready_workspaces/2.11/html/release_notes_and_known_issues/index";
export declare const DOCS_LINK_INSTALL_RUNNING_CHE_LOCALLY = "https://www.eclipse.org/che/docs/che-7/installation-guide/installing-che-locally/";
export declare const DOCS_LINK_IMPORT_CA_CERT_INTO_BROWSER = "https://www.eclipse.org/che/docs/che-7/end-user-guide/importing-certificates-to-browsers/";
export declare const DOCS_LINK_HOW_TO_ADD_IDENTITY_PROVIDER_OS4 = "https://docs.openshift.com/container-platform/latest/authentication/understanding-identity-provider.html#identity-provider-overview_understanding-identity-provider";
export declare const DOCS_LINK_HOW_TO_CREATE_USER_OS3 = "https://docs.openshift.com/container-platform/3.11/install_config/configuring_authentication.html";
export declare const DOC_LINK_OBTAIN_ACCESS_TOKEN = "https://www.eclipse.org/che/docs/che-7/administration-guide/authenticating-users/#obtaining-the-token-from-keycloak_authenticating-to-the-che-server";
export declare const DOC_LINK_OBTAIN_ACCESS_TOKEN_OAUTH = "https://www.eclipse.org/che/docs/che-7/administration-guide/authenticating-users/#obtaining-the-token-from-openshift-token-through-keycloak_authenticating-to-the-che-server";
export declare const OUTPUT_SEPARATOR = "-------------------------------------------------------------------------------";
export declare const DEFAULT_DEV_WORKSPACE_CONTROLLER_NAMESPACE = "devworkspace-controller";
export declare const DEFAULT_ANALYTIC_HOOK_NAME = "analytics";
export declare const DEFAULT_K8S_POD_WAIT_TIMEOUT = 600000;
export declare const DEFAULT_K8S_POD_ERROR_RECHECK_TIMEOUT = 15000;
export declare const CHE_CLUSTER_CRD = "checlusters.org.eclipse.che";
export declare const CHE_CLUSTER_API_GROUP = "org.eclipse.che";
export declare const CHE_CLUSTER_API_VERSION = "v1";
export declare const CHE_CLUSTER_KIND_PLURAL = "checlusters";
export declare const CHE_BACKUP_SERVER_CONFIG_CRD = "chebackupserverconfigurations.org.eclipse.che";
export declare const CHE_BACKUP_SERVER_CONFIG_KIND_PLURAL = "chebackupserverconfigurations";
export declare const CHE_CLUSTER_BACKUP_CRD = "checlusterbackups.org.eclipse.che";
export declare const CHE_CLUSTER_BACKUP_KIND_PLURAL = "checlusterbackups";
export declare const CHE_CLUSTER_RESTORE_CRD = "checlusterrestores.org.eclipse.che";
export declare const CHE_CLUSTER_RESTORE_KIND_PLURAL = "checlusterrestores";
