"use strict";
/**
 * Copyright (c) 2019-2021 Red Hat, Inc.
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *   Red Hat, Inc. - initial API and implementation
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const command_1 = require("@oclif/command");
const cli_ux_1 = require("cli-ux");
const che_1 = require("../../api/che");
const context_1 = require("../../api/context");
const kube_1 = require("../../api/kube");
const version_1 = require("../../api/version");
const common_flags_1 = require("../../common-flags");
const constants_1 = require("../../constants");
const util_1 = require("../../util");
class Status extends command_1.Command {
    run() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const { flags } = this.parse(Status);
            flags.chenamespace = yield util_1.findWorkingNamespace(flags);
            yield context_1.ChectlContext.init(flags, this);
            const kube = new kube_1.KubeHelper(flags);
            const che = new che_1.CheHelper(flags);
            let openshiftOauth = 'No';
            yield this.config.runHook(constants_1.DEFAULT_ANALYTIC_HOOK_NAME, { command: Status.id, flags });
            const cr = yield kube.getCheCluster(flags.chenamespace);
            if (cr && cr.spec && cr.spec.auth && cr.spec.auth.openShiftoAuth && (yield kube.isOpenShift())) {
                openshiftOauth = 'Yes';
            }
            const cheVersion = yield version_1.VersionHelper.getCheVersion(flags);
            cli_ux_1.cli.log(`CodeReady Workspaces Version    : ${cheVersion}`);
            cli_ux_1.cli.log(`CodeReady Workspaces Url        : ${yield che.cheURL(flags.chenamespace)}`);
            cli_ux_1.cli.log(`OpenShift OAuth enabled: ${openshiftOauth}\n`);
        });
    }
}
exports.default = Status;
// Implementation-Version it is a property from Manifest.ml inside of che server pod which indicate CodeReady Workspaces build version.
Status.description = 'Status CodeReady Workspaces server';
Status.flags = {
    help: command_1.flags.help({ char: 'h' }),
    chenamespace: common_flags_1.cheNamespace,
    telemetry: common_flags_1.CHE_TELEMETRY,
};
//# sourceMappingURL=status.js.map