"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const path = require("path");
const base_1 = require("../../base");
class Script extends base_1.AutocompleteBase {
    async run() {
        const { args } = this.parse(Script);
        const shell = args.shell || this.config.shell;
        this.errorIfNotSupportedShell(shell);
        const binUpcase = this.cliBinEnvVar;
        const shellUpcase = shell.toUpperCase();
        this.log(`${this.prefix}${binUpcase}_AC_${shellUpcase}_SETUP_PATH=${path.join(this.autocompleteCacheDir, `${shell}_setup`)} && test -f $${binUpcase}_AC_${shellUpcase}_SETUP_PATH && source $${binUpcase}_AC_${shellUpcase}_SETUP_PATH;${this.suffix}`);
    }
    get prefix() {
        return '\n';
    }
    get suffix() {
        return ` # ${this.cliBin} autocomplete setup\n`;
    }
}
exports.default = Script;
Script.description = 'outputs autocomplete config script for shells';
Script.hidden = true;
Script.args = [{ name: 'shell', description: 'shell type', required: false }];
