/*********************************************************************
 * Copyright (c) 2019 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 **********************************************************************/
import { Command } from '@oclif/command';
export default class Logs extends Command {
    static description: string;
    static flags: {
        help: import("@oclif/parser/lib/flags").IBooleanFlag<void>;
        chenamespace: import("@oclif/parser/lib/flags").IOptionFlag<string>;
        'listr-renderer': import("@oclif/parser/lib/flags").IOptionFlag<string>;
        'deployment-name': import("@oclif/parser/lib/flags").IOptionFlag<string>;
        directory: import("@oclif/parser/lib/flags").IOptionFlag<string | undefined>;
        'skip-kubernetes-health-check': import("@oclif/parser/lib/flags").IBooleanFlag<boolean>;
    };
    run(): Promise<void>;
}
