/*********************************************************************
 * Copyright (c) 2020 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 **********************************************************************/
import Command from '@oclif/command';
import * as Listr from 'listr';
import { CheHelper } from '../../api/che';
import { KubeHelper } from '../../api/kube';
import { OpenShiftHelper } from '../../api/openshift';
/**
 * Handle setup of the dev workspace operator controller.
 */
export declare class DevWorkspaceTasks {
    private readonly flags;
    protected kubeHelper: KubeHelper;
    protected cheHelper: CheHelper;
    protected openShiftHelper: OpenShiftHelper;
    protected devWorkspaceServiceAccount: string;
    protected devWorkspaceRole: string;
    protected devWorkspaceEditWorkspaceClusterRole: string;
    protected devWorkspaceViewWorkspaceClusterRole: string;
    protected devWorkspaceRoleBinding: string;
    protected deploymentName: string;
    constructor(flags: any);
    getTemplatePath(): string;
    getNamespace(): any;
    /**
     * Returns list of tasks which setup dev-workspace.
     */
    getInstallTasks(flags: any, command: Command): ReadonlyArray<Listr.ListrTask>;
    /**
     * Returns list of tasks which uninstall dev-workspace.
     */
    getUninstallTasks(): ReadonlyArray<Listr.ListrTask>;
}
