"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.KubeTasks = void 0;
const tslib_1 = require("tslib");
const Listr = require("listr");
const kube_1 = require("../api/kube");
class KubeTasks {
    constructor(flags) {
        this.debug = require('debug');
        this.kube = new kube_1.KubeHelper(flags);
    }
    podStartTasks(_command, selector, namespace = '') {
        return new Listr([
            {
                title: 'scheduling',
                task: (_ctx, task) => tslib_1.__awaiter(this, void 0, void 0, function* () {
                    let phase;
                    const title = task.title;
                    try {
                        phase = yield this.kube.getPodPhase(selector, namespace);
                    }
                    catch (err) {
                        // not able to grab current phase
                        this.debug(err);
                    }
                    // wait only if not yet running
                    if (phase !== 'Running') {
                        yield this.kube.waitForPodPending(selector, namespace);
                    }
                    task.title = `${title}...done.`;
                })
            },
            {
                title: 'downloading images',
                task: (_ctx, task) => tslib_1.__awaiter(this, void 0, void 0, function* () {
                    yield this.kube.waitForPodPhase(selector, 'Running', namespace);
                    task.title = `${task.title}...done.`;
                })
            },
            {
                title: 'starting',
                task: (_ctx, task) => tslib_1.__awaiter(this, void 0, void 0, function* () {
                    yield this.kube.waitForPodReady(selector, namespace);
                    task.title = `${task.title}...done.`;
                })
            }
        ]);
    }
}
exports.KubeTasks = KubeTasks;
//# sourceMappingURL=kube.js.map