/*********************************************************************
 * Copyright (c) 2019-2020 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 **********************************************************************/
import { che as chetypes } from '@eclipse-che/api';
export declare class CheApiClient {
    defaultCheResponseTimeoutMs: number;
    readonly cheApiEndpoint: string;
    private readonly axios;
    private constructor();
    static getInstance(cheApiEndpoint: string): CheApiClient;
    private static normalizeCheApiEndpointUrl;
    /**
     * Checks whether provided url really points to Che server API.
     * Throws an exception if it's not.
     */
    checkCheApiEndpointUrl(responseTimeoutMs?: number): Promise<void>;
    isCheServerReady(responseTimeoutMs?: number): Promise<boolean>;
    getCheServerStatus(responseTimeoutMs?: number): Promise<string>;
    startCheServerShutdown(accessToken?: string, responseTimeoutMs?: number): Promise<void>;
    waitUntilCheServerReadyToShutdown(intervalMs?: number, timeoutMs?: number): Promise<void>;
    /**
     * Returns list of all workspaces of the user.
     */
    getAllWorkspaces(accessToken?: string): Promise<chetypes.workspace.Workspace[]>;
    /**
     * Returns list of workspaces in given range.
     * If lst of all workspaces is needed, getAllWorkspaces should be used insted.
     */
    getWorkspaces(skipCount?: number, maxItems?: number, accessToken?: string): Promise<chetypes.workspace.Workspace[]>;
    getWorkspaceById(workspaceId: string, accessToken?: string): Promise<chetypes.workspace.Workspace>;
    deleteWorkspaceById(workspaceId: string, accessToken?: string): Promise<void>;
    startWorkspace(workspaceId: string, debug: boolean, accessToken?: string): Promise<void>;
    stopWorkspace(workspaceId: string, accessToken?: string): Promise<void>;
    createWorkspaceFromDevfile(devfileContent: string, accessToken?: string): Promise<chetypes.workspace.Workspace>;
    isAuthenticationEnabled(responseTimeoutMs?: number): Promise<boolean>;
    getCheApiError(error: any, endpoint: string): Error;
}
