/*********************************************************************
 * Copyright (c) 2020 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 **********************************************************************/
import * as Listr from 'listr';
import { CheHelper } from '../../api/che';
import { KubeHelper } from '../../api/kube';
export declare const CERT_MANAGER_CA_SECRET_NAME = "ca";
export declare const DEFAULT_CHE_CLUSTER_ISSUER_NAME = "che-cluster-issuer";
export declare class CertManagerTasks {
    protected kubeHelper: KubeHelper;
    protected cheHelper: CheHelper;
    constructor(flags: any);
    /**
     * Verify if cert-manager is installed in cluster
     */
    getDeployCertManagerTasks(flags: any): ReadonlyArray<Listr.ListrTask>;
    /**
     * Returns list of tasks which perform cert-manager checks and requests self-signed certificate for Che.
     */
    getGenerateCertificatesTasks(flags: any): ReadonlyArray<Listr.ListrTask>;
}
