/*******************************************************************************
 * Copyright (c) 2007 Exadel, Inc. and Red Hat, Inc.
 * Distributed under license by Red Hat, Inc. All rights reserved.
 * This program is made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Exadel, Inc. and Red Hat, Inc. - initial API and implementation
 ******************************************************************************/ 
package org.jboss.tools.hibernate.wizard.hibernatecachewizard.ui;

import java.util.*;
import org.eclipse.jface.viewers.*;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;
import org.jboss.tools.hibernate.wizard.hibernatecachewizard.HibernateCacheWizard;
import org.jboss.tools.hibernate.wizard.hibernatecachewizard.datamodel.*;


public class CachedClassesPage extends CommonCachedPage {

	public CachedClassesPage(String pagetitle, Set items, Set cached_items) {
		super(pagetitle,ICacheable.bundle.getString("HibernateCacheWizard.LIST_CACHEABLE_CLASSES"),ICacheable.bundle.getString("HibernateCacheWizard.LIST_CACHED_CLASSES"));
		Incoming 	= new HashSet((Collection)items);
		Cached		= new HashSet((Collection)cached_items);
	}

	public void setCallback(Wizard callback) {
		CallBack = (HibernateCacheWizard)callback;
	}

	/**
	 * Create controls for a sheet.
	 */
	public void createControl(Composite parent) {
	// create main composite.
		Composite thecomposite = new Composite(parent, SWT.NONE);
		thecomposite.setLayout(new GridLayout(3,false));
    // 	set page content.
		createPageContent(thecomposite);
		setDescription(ICacheable.bundle.getString("HibernateCacheWizard.CACHING_CLASSES_DESCR"));
	// page settings
		setControl(thecomposite);
		setPageComplete(true);
	}

	private void createPageContent(Composite parent)
	{
		createPageElements(parent);
		createPopupMenu();
	}

	protected void createPageElements(Composite parent)
	{
		createInitialDescriptor(parent);
		createEmptyDescriptor(parent);
		createComposedDescriptor(parent);
		createInitialViewer(parent);
		createControlButtons(parent);		
		createCachedViewer(parent);
		
		stuffInitialViewer();
		stuffCachedViewer();
		enableControlButtons(false);
		setDefaultSelectionForList(true, true);
		processGroupButtons();
	}

	private void createInitialViewer(Composite parent)
	{
		InitialViewer 		= new ListViewer(parent);
		InitialViewer.getControl().setLayoutData(calculateTreeViewerSize(GridData.FILL_BOTH));
		InitialViewer.addSelectionChangedListener(new HibernateCacheWizardSelectionListener());
		ListContentProvider = new ListDataModelContentProvider();
		Sorter				= new ListSorter();
		InitialViewer.setContentProvider(ListContentProvider);
		InitialViewer.setSorter(Sorter);
	}

	private void createCachedViewer(Composite parent)
	{
		CachedViewer 		= new ListViewer(parent);
		CachedViewer.getControl().setLayoutData(calculateTreeViewerSize(GridData.FILL_BOTH));
		CachedViewer.addSelectionChangedListener(new HibernateCacheWizardSelectionListener());
		ListContentProvider = new ListDataModelContentProvider();
		Sorter				= new ListSorter();
		CachedViewer.setContentProvider(ListContentProvider);
		CachedViewer.setSorter(Sorter);
	}

	private void stuffInitialViewer()
	{		InitialViewer.setInput(Incoming);		}
	private void stuffCachedViewer()
	{		CachedViewer.setInput(Cached);			}

	protected void createInitialDescriptor(Composite parent) 
	{
		Label description 	= new Label(parent,SWT.NONE);
		description.setText(ICacheable.bundle.getString("HibernateCacheWizard.LIST_CACHEABLE_CLASSES"));
		GridData gd 		= new GridData(GridData.FILL_HORIZONTAL);
		gd.horizontalSpan 	= 1;
		description.setLayoutData(gd);
	}

	protected void createComposedDescriptor(Composite parent) 
	{
		Label description 	= new Label(parent,SWT.NONE);
		description.setText(ICacheable.bundle.getString("HibernateCacheWizard.LIST_CACHED_CLASSES"));
		GridData gd 		= new GridData(GridData.FILL_HORIZONTAL);
		gd.horizontalSpan 	= 1;
		description.setLayoutData(gd);
	}

	private void createEmptyDescriptor(Composite parent)
	{
		Label description 	= new Label(parent,SWT.NONE);
		description.setText(ICacheable.bundle.getString("HibernateCacheWizard.EMPTY_STRING"));
		GridData gd 		= new GridData(GridData.FILL_HORIZONTAL);
		gd.horizontalSpan 	= 1;
		description.setLayoutData(gd);
	}

	protected void createPopupMenu()
	{
		super.createPopupMenu();
		//InitialViewer.getControl().setMenu(CacheContextMenu);
		CachedViewer.getControl().setMenu(CacheContextMenu);
	}
	private String prepareCachedClassName(String name)
	{
		String newname = name;
		//String param = (isInitialSelected()) ? cacheConcurrencyStrategy : bundle.getString("HibernateCacheWizard.transactional");
		newname += (ICacheable.bundle.getString("HibernateCacheWizard.CACHED_STRATEGY_TOKEN") + cacheConcurrencyStrategy);
		return newname;
	}

	private String prepareCacheableClassName(String name)
	{
		String newname = name;
		String[] tokens = newname.split(ICacheable.bundle.getString("HibernateCacheWizard.CACHED_STRATEGY_TOKEN"));
		return tokens[0];// return classname w/o cached strategy name.
	}

	private void classNamesTransfer(Iterator it, int transtype)
	{
		while(it.hasNext())
		{
			String name = (String)it.next();
			if(transtype == ICacheable.ADD_TO_CACHE ) 
			{
				addToCache(name);
			} 
			else 
			{
				removeFromCache(name) ;
			}
		}
		updateUI();
	}

	/**
	 * Description copied from: CommonCachedPage class. 
	 * Add item to cache or remove item from cache. 
	 * @param name - name of item;
	 * @param param - cacheable parameter (concurrency strategy). if <param> == null remove item from cache.
	 */
	protected void itemAddRemoveCache(String name, String param, boolean strategy)
	{
		CallBack.cacheClass(name,param, strategy);
	}
	private void addToCache(String name)
	{
		itemAddRemoveCache(name,cacheConcurrencyStrategy, false);
		cacheableToCachedUITransfer(name);
	}

	private void cacheableToCachedUITransfer(String name)
	{
		if( Incoming.contains(name) )
		{
			Cached.add(prepareCachedClassName(name));
			//1Incoming.remove(name);
		}
	}

	private void removeFromCache(String name)
	{
		removeClassFromCache(name);
		cacheToCacheableTransfer(name);
	}

	private void removeClassFromCache(String name)
	{
		itemAddRemoveCache(name,null, false);
	}

	private void cacheToCacheableTransfer(String name)
	{
		if( Cached.contains(name) )
		{
			Incoming.add(prepareCacheableClassName(name));
			//1Cached.remove(name);
		}
	}

	protected void updateUI()
	{
		updateInitialViewer();
		updateComposedViewer();

		processGroupButtons();
	}

	protected void updateInitialViewer()
	{
		InitialViewer.setInput(null);
		stuffInitialViewer();
		InitialViewer.refresh(false);
	}

	protected void WriteToCache(String name)
	{
		String item_name_strat = name;
		String[]item_names = item_name_strat.split(ICacheable.bundle.getString("HibernateCacheWizard.CACHED_STRATEGY_TOKEN")); 
		itemAddRemoveCache(item_names[0],cacheConcurrencyStrategy, true);	
	}
	protected void updateComposedViewer()
	{
		CachedViewer.setInput(null);
		stuffCachedViewer();
		CachedViewer.refresh(true);
	}

	private void cleanSet(Iterator it,boolean incom)
	{
		while(it.hasNext())
		{
			Set temp = (incom) ? Incoming : Cached;
			temp.remove(it.next());
		}
	}

	protected void processAddToCacheButtonPressed()
	{
		StructuredSelection sel = (StructuredSelection)InitialViewer.getSelection();
		if(sel.size() < 1)// if have not selected items - do nothing.
			return;

		classNamesTransfer(sel.iterator(),ICacheable.ADD_TO_CACHE);
		cleanSet(sel.iterator(),true);
		updateUI();
		// set default selection;
		setDefaultSelectionForList(true, true);
		processButtonsState();
	}

	protected void processAddAllToCacheButtonPressed()
	{
		if(Incoming.size() < 1)
			return;
		classNamesTransfer(Incoming.iterator(),ICacheable.ADD_TO_CACHE);
		Incoming.clear();
		updateUI();
		processButtonsState();
	}

	protected void processRemoveFromCachePressed()
	{
		StructuredSelection sel = (StructuredSelection)CachedViewer.getSelection();
		if(sel.size() < 1)// if have not selected items - do nothing.
			return;
		classNamesTransfer(sel.iterator(),ICacheable.REMOVE_FROM_CACHE);
		cleanSet(sel.iterator(), false);
		updateUI();
		// set default selection;
		setDefaultSelectionForList(false, true);
		processButtonsState();
	}

	protected void processRemoveAllFromCachePressed()
	{
		if(Cached.size() < 1)
			return;
		classNamesTransfer(Cached.iterator(),ICacheable.REMOVE_FROM_CACHE);
		Cached.clear();
		updateUI();
		processButtonsState();
	}
}

