package org.jbpm.gd.jpdl.model;

import java.util.ArrayList;
import java.util.List;

public class MailNode extends AbstractNode {

	private List subjects = new ArrayList();
	private List texts = new ArrayList();
	private String template;
	private String actors;
	private String to;
	private String subject;
	private String text;
	
	public void addSubject(Subject subject) {
		subjects.add(subject);
		firePropertyChange("subjectAdd", null, subject);
	}
	
	public void removeSubject(Subject subject) {
		subjects.remove(subject);
		firePropertyChange("subjectRemove", subject, null);
	}
	
	public Subject[] getSubjects() {
		return (Subject[])subjects.toArray(new Subject[subjects.size()]);
	}
	
	public void addText(Text text) {
		texts.add(text);
		firePropertyChange("text", null, text);
	}
	
	public void removeText(Text text) {
		texts.remove(text);
		firePropertyChange("text", text, null);
	}
	
	public Text[] getTexts() {
		return (Text[])texts.toArray(new Text[texts.size()]);
	}
	
	public void setTemplate(String newTemplate) {
		String oldTemplate = template;
		template = newTemplate;
		firePropertyChange("template", oldTemplate, newTemplate);
	}
	
	public String getTemplate() {
		return template;
	}
	
	public void setActors(String newActors) {
		String oldActors = actors;
		actors = newActors;
		firePropertyChange("actors", oldActors, newActors);
	}
	
	public String getActors() {
		return actors;
	}
	
	public void setTo(String newTo) {
		String oldTo = to;
		to = newTo;
		firePropertyChange("to", oldTo, newTo);
	}
	
	public String getTo() {
		return to;
	}
	
	public void setSubject(String newSubject) {
		String oldSubject = subject;
		subject = newSubject;
		firePropertyChange("subject", oldSubject, newSubject);
	}
	
	public String getSubject() {
		return subject;
	}
	
	public void setText(String newText) {
		String oldText = text;
		text = newText;
		firePropertyChange("text", oldText, newText);
	}
	
	public String getText() {
		return text;
	}
	
}
