package org.jbpm.gd.jpdl.xml;

import java.beans.PropertyChangeEvent;

import org.jbpm.gd.jpdl.model.ConfigInfoElement;
import org.jbpm.gd.jpdl.model.AbstractJpdlElement;

public class ConfigInfoElementDomAdapter extends JpdlElementDomAdapter {
	
	protected void initialize(AbstractJpdlElement jpdlElement) {
		super.initialize(jpdlElement);
		ConfigInfoElement configInfoElement = (ConfigInfoElement)jpdlElement;
		configInfoElement.setName(getNode().getNodeName());
		configInfoElement.setValue(getTextContent());
		configInfoElement.addPropertyChangeListener(this);
	}
	
	protected void initialize() {
		super.initialize();
		ConfigInfoElement configInfoElement = (ConfigInfoElement)getJpdlElement();
		if (configInfoElement != null ) {
			setTextContent(configInfoElement.getValue());
		}
	}
	
	public void propertyChange(PropertyChangeEvent evt) {
		if ("value".equals(evt.getPropertyName())) {
			setTextContent((String)evt.getNewValue());
		} else if ("configInfoElementAdd".equals(evt.getPropertyName())) {
			addElement((ConfigInfoElement)evt.getNewValue());
		} else if ("configInfoElementRemove".equals(evt.getPropertyName())) {
			removeElement((ConfigInfoElement)evt.getOldValue());
		}
	}
	
	protected void doModelUpdate(String name, String newValue) {
		ConfigInfoElement configInfoElement = (ConfigInfoElement)getJpdlElement();
		if ("#text".equals(name)) {
			configInfoElement.setValue(newValue);
		}
	}
	
	protected void doModelAdd(JpdlElementDomAdapter child) {
		// a controller cannot have any child nodes
	}
	
	protected void doModelRemove(JpdlElementDomAdapter child) {
		// a controller cannot have any child nodes
	}
	
	protected String getElementType() {
		return "configInfoElement";
	}
}
