package org.jbpm.gd.jpdl.xml;

import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import java.util.Map;

import org.jbpm.gd.jpdl.model.Action;
import org.jbpm.gd.jpdl.model.ExceptionHandler;
import org.jbpm.gd.jpdl.model.AbstractJpdlElement;
import org.jbpm.gd.jpdl.model.JpdlElementFactory;
import org.jbpm.gd.jpdl.model.Script;

public class ExceptionHandlerDomAdapter extends JpdlElementDomAdapter {
	
	private static final String[] CHILD_ELEMENTS = {"action-element"};
	private static HashMap NODE_TYPES = null;
	
	protected String[] getChildElements() {
		return CHILD_ELEMENTS;
	}
	
	protected Map getNodeTypes() {
		if (NODE_TYPES == null) {
			NODE_TYPES = new HashMap();
			NODE_TYPES.put("action", "action-element");
			NODE_TYPES.put("script", "action-element");
		}
		return NODE_TYPES;
	}
	
	protected void initialize(AbstractJpdlElement jpdlElement) {
		super.initialize(jpdlElement);
		ExceptionHandler exceptionHandler = (ExceptionHandler)jpdlElement;
		exceptionHandler.setExceptionClass(getAttribute("exception-class"));
		exceptionHandler.addPropertyChangeListener(this);
	}
	
	protected void initialize() {
		super.initialize();
		ExceptionHandler exceptionHandler = (ExceptionHandler)getJpdlElement();
		if (exceptionHandler != null) {
			setAttribute("exception-class", exceptionHandler.getExceptionClass());
			addElements(exceptionHandler.getActionElements());
		}
	}

	public void propertyChange(PropertyChangeEvent evt) {
		if ("actionAdd".equals(evt.getPropertyName())) {
			addElement((Action)evt.getNewValue());
		} else if ("actionRemove".equals(evt.getPropertyName())) {
			removeElement((Action)evt.getOldValue());
		} else if ("scriptAdd".equals(evt.getPropertyName())) {
			addElement((Script)evt.getNewValue());
		} else if ("scriptRemove".equals(evt.getPropertyName())) {
			removeElement((Script)evt.getOldValue());
		} else if ("exceptionClass".equals(evt.getPropertyName())) {
			setAttribute("exception-class", (String)evt.getNewValue());
		}
	}
	
	protected void doModelUpdate(String name, String newValue) {
		ExceptionHandler exceptionHandler = (ExceptionHandler)getJpdlElement();
		if ("exception-class".equals(name)) {
			exceptionHandler.setExceptionClass(newValue);
		}
	}
	
	protected void doModelAdd(JpdlElementDomAdapter child) {
		String type = child.getElementType();
		ExceptionHandler exceptionHandler = (ExceptionHandler)getJpdlElement();
		AbstractJpdlElement jpdlElement = JpdlElementFactory.INSTANCE.createByName(child.getElementType());
		child.initialize(jpdlElement);
		if ("action".equals(type)) {
			exceptionHandler.addAction((Action)jpdlElement);
		} else if ("script".equals(type)) {
			exceptionHandler.addScript((Script)jpdlElement);
		}
	}
	
	protected void doModelRemove(JpdlElementDomAdapter child) {
		String type = child.getElementType();
		ExceptionHandler exceptionHandler = (ExceptionHandler)getJpdlElement();
		if ("action".equals(type)) {
			exceptionHandler.removeAction((Action)child.getJpdlElement());
		} else if ("script".equals(type)) {
			exceptionHandler.removeScript((Script)child.getJpdlElement());
		}
	}
	
}
