package org.jbpm.gd.jpdl.xml;

import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import java.util.Map;

import org.jbpm.gd.jpdl.model.Assignment;
import org.jbpm.gd.jpdl.model.AbstractJpdlElement;
import org.jbpm.gd.jpdl.model.JpdlElementFactory;
import org.jbpm.gd.jpdl.model.Swimlane;

public class SwimlaneDomAdapter extends JpdlElementDomAdapter {
	
	private static HashMap NODE_TYPES = null;
	
	protected Map getNodeTypes() {
		if (NODE_TYPES == null) {
			NODE_TYPES = new HashMap();
			NODE_TYPES.put("assignment", "assignment");
		}
		return NODE_TYPES;
	}
	
	protected void initialize() {
		super.initialize();
		Swimlane swimlane  = (Swimlane)getJpdlElement();
		if (swimlane != null) {
			setAttribute("name", swimlane.getName());
			addElement(swimlane.getAssignment());
		}
	}
	
	protected void initialize(AbstractJpdlElement jpdlElement) {
		super.initialize(jpdlElement);
		Swimlane swimlane = (Swimlane)jpdlElement;
		swimlane.setName(getAttribute("name"));
		swimlane.addPropertyChangeListener(this);
	}

	public void propertyChange(PropertyChangeEvent evt) {
		if ("name".equals(evt.getPropertyName())) {
			setAttribute("name", (String)evt.getNewValue());
		} else if ("assignment".equals(evt.getPropertyName())) {
			setElement("assignment", (AbstractJpdlElement)evt.getOldValue(), (AbstractJpdlElement)evt.getNewValue());
		}
	}
	
	protected void doModelUpdate(String name, String newValue) {
		Swimlane swimlane = (Swimlane)getJpdlElement();
		if ("name".equals(name)) {
			swimlane.setName(newValue);
		}
	}
	
	protected void doModelAdd(JpdlElementDomAdapter child) {
		String type = child.getElementType();
		Swimlane swimlane = (Swimlane)getJpdlElement();
		AbstractJpdlElement jpdlElement = JpdlElementFactory.INSTANCE.createByName(type);
		child.initialize(jpdlElement);
		if ("assignment".equals(type)) {
			swimlane.setAssignment((Assignment)jpdlElement);
		}
	}
	
	protected void doModelRemove(JpdlElementDomAdapter child) {
		String type = child.getElementType();
		Swimlane swimlane = (Swimlane)getJpdlElement();
		if ("assignment".equals(type)) {
			swimlane.setAssignment(null);
		}
	}
	
}
