package org.jbpm.gd.jpdl.ui.properties;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.jbpm.gd.common.notation.AbstractNotationElement;
import org.jbpm.gd.jpdl.model.CreateTimer;
import org.jbpm.gd.jpdl.ui.graph.part.NotationElementGraphicalEditPart;
import org.jbpm.gd.jpdl.ui.outline.part.JpdlOutlineEditPart;


public class CreateTimerSection extends AbstractPropertySection {
	
	private CreateTimerConfigurationComposite createTimerConfigurationComposite;
	private CreateTimer createTimer;
	
	public void createControls(Composite parent,
            TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        Composite clientArea = getWidgetFactory().createFlatFormComposite(parent);
        createTimerConfigurationComposite = CreateTimerConfigurationComposite.create(getWidgetFactory(), clientArea);
    }
 
 	public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        if (!(selection instanceof IStructuredSelection)) return;
        Object input = ((IStructuredSelection)selection).getFirstElement();
        if (input instanceof NotationElementGraphicalEditPart) {
        	AbstractNotationElement notationElement = ((NotationElementGraphicalEditPart)input).getNotationElement();
        	input = notationElement.getSemanticElement();
        } else if (input instanceof JpdlOutlineEditPart) {
        	input = ((JpdlOutlineEditPart)input).getModel();
        }
        if (input instanceof CreateTimer) {
        	setCreateTimer((CreateTimer)input);
        }
    }
 	
 	private void setCreateTimer(CreateTimer createTimer) {
 		this.createTimer = createTimer;
 	}

 	public void refresh() {
 		if (createTimer != null) {
 			createTimerConfigurationComposite.setCreateTimer(createTimer);
 		}
    }
 	
	public boolean shouldUseExtraSpace() {
		return true;
	}
	
}