/*
 * JBoss, the OpenSource EJB server
 * 
 * Distributable under LGPL license. See terms of license at gnu.org.
 */

package javax.resource.spi;

import javax.resource.ResourceException;

/**
 * Thrown when a shared connection is used in an unshareable manner.
 */
public class SharingViolationException extends ResourceException
{
   /**
	 * Create an exception.
	 */
   public SharingViolationException()
   {
      super();
   }

   /**
	 * Create an exception with a reason.
	 * 
	 * @param reason the reason
	 */
   public SharingViolationException(String reason)
   {
      super(reason);
   }

   /**
	 * Create an exception with a reason and an errorCode.
	 * 
	 * @param reason the reason
	 * @param errorCode the error code
	 */
   public SharingViolationException(String reason, String errorCode)
   {
      super(reason, errorCode);
   }

   /**
	 * Create an exception with a reason and an error.
	 * 
	 * @param reason the reason
	 * @param throwable the error
	 */
   public SharingViolationException(String reason, Throwable throwable)
   {
      super(reason, throwable);
   }

   /**
	 * Create an exception with an error.
	 * 
	 * @param throwable the error
	 */
   public SharingViolationException(Throwable throwable)
   {
      super(throwable);
   }
}