/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.tempdata;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.teiid.api.exception.query.QueryProcessingException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.core.TeiidComponentException;
import org.teiid.query.QueryPlugin;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.metadata.TempMetadataStore;
import org.teiid.query.resolver.command.TempTableResolver;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Create;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.tempdata.TempTable;

public class TempTableStore {
    private ConcurrentHashMap<String, MatTableInfo> matTables = new ConcurrentHashMap();
    private TempMetadataStore tempMetadataStore = new TempMetadataStore(new ConcurrentHashMap<String, TempMetadataID>());
    private Map<String, TempTable> groupToTupleSourceID = new ConcurrentHashMap<String, TempTable>();
    private String sessionID;
    private TempTableStore parentTempTableStore;

    public TempTableStore(String sessionID) {
        this.sessionID = sessionID;
    }

    public MatTableInfo getMatTableInfo(String tableName) {
        MatTableInfo newInfo = new MatTableInfo();
        MatTableInfo info = this.matTables.putIfAbsent(tableName, newInfo);
        if (info == null) {
            info = newInfo;
        }
        return info;
    }

    public void setParentTempTableStore(TempTableStore parentTempTableStore) {
        this.parentTempTableStore = parentTempTableStore;
    }

    public boolean hasTempTable(String tempTableName) {
        return this.groupToTupleSourceID.containsKey(tempTableName);
    }

    TempTable addTempTable(String tempTableName, Create create, BufferManager buffer, boolean add) {
        List<ElementSymbol> columns = create.getColumns();
        TempMetadataID id = this.tempMetadataStore.getTempGroupID(tempTableName);
        if (id == null) {
            id = this.tempMetadataStore.addTempGroup(tempTableName, columns, false, true);
            TempTableResolver.addPrimaryKey(create, id);
        }
        columns = new ArrayList<ElementSymbol>(create.getColumns());
        if (!create.getPrimaryKey().isEmpty()) {
            List<ElementSymbol> primaryKey = create.getPrimaryKey();
            columns.removeAll(primaryKey);
            columns.addAll(0, primaryKey);
        }
        TempTable tempTable = new TempTable(id, buffer, columns, create.getPrimaryKey().size(), this.sessionID);
        if (add) {
            this.groupToTupleSourceID.put(tempTableName, tempTable);
        }
        return tempTable;
    }

    void swapTempTable(String tempTableName, TempTable tempTable) {
        this.groupToTupleSourceID.put(tempTableName, tempTable);
    }

    public void removeTempTableByName(String tempTableName) {
        this.tempMetadataStore.removeTempGroup(tempTableName);
        TempTable table = this.groupToTupleSourceID.remove(tempTableName);
        if (table != null) {
            table.remove();
        }
    }

    public TempMetadataStore getMetadataStore() {
        return this.tempMetadataStore;
    }

    public void removeTempTables() {
        for (String name : this.groupToTupleSourceID.keySet()) {
            this.removeTempTableByName(name);
        }
    }

    TempTable getOrCreateTempTable(String tempTableID, Command command, BufferManager buffer, boolean delegate) throws QueryProcessingException {
        Insert insert;
        GroupSymbol group;
        TempTable tsID = this.groupToTupleSourceID.get(tempTableID);
        if (tsID != null) {
            return tsID;
        }
        if (delegate && this.parentTempTableStore != null && (tsID = this.parentTempTableStore.groupToTupleSourceID.get(tempTableID)) != null) {
            return tsID;
        }
        List columns = null;
        if (command instanceof Insert && (group = (insert = (Insert)command).getGroup()).isImplicitTempGroupSymbol()) {
            columns = insert.getVariables();
        }
        if (columns == null) {
            throw new QueryProcessingException(QueryPlugin.Util.getString("TempTableStore.table_doesnt_exist_error", new Object[]{tempTableID}));
        }
        Create create = new Create();
        create.setTable(new GroupSymbol(tempTableID));
        create.setColumns(columns);
        return this.addTempTable(tempTableID, create, buffer, true);
    }

    public Set<String> getAllTempTables() {
        return new HashSet<String>(this.groupToTupleSourceID.keySet());
    }

    public static class MatTableInfo {
        private long updateTime = -1L;
        private MatState state = MatState.NEEDS_LOADING;
        private long ttl = -1L;
        private boolean valid;

        synchronized boolean shouldLoad() throws TeiidComponentException {
            block7: while (true) {
                switch (this.state) {
                    case NEEDS_LOADING: 
                    case FAILED_LOAD: {
                        this.setState(MatState.LOADING);
                        return true;
                    }
                    case LOADING: {
                        if (this.valid) {
                            return false;
                        }
                        try {
                            this.wait();
                            continue block7;
                        }
                        catch (InterruptedException e) {
                            throw new TeiidComponentException((Throwable)e);
                        }
                    }
                    case LOADED: {
                        if (this.ttl >= 0L && System.currentTimeMillis() - this.updateTime - this.ttl > 0L) {
                            this.setState(MatState.LOADING);
                            return true;
                        }
                        return false;
                    }
                }
            }
        }

        public synchronized MatState setState(MatState state, Boolean valid, Long timestamp) {
            MatState oldState = this.state;
            if (valid != null) {
                this.valid = valid;
            }
            this.setState(state);
            if (timestamp != null) {
                this.updateTime = timestamp;
            }
            this.notifyAll();
            return oldState;
        }

        private void setState(MatState state) {
            this.state = state;
            this.updateTime = System.currentTimeMillis();
        }

        public synchronized void setTtl(long ttl) {
            this.ttl = ttl;
        }

        public synchronized long getUpdateTime() {
            return this.updateTime;
        }

        public synchronized MatState getState() {
            return this.state;
        }

        public synchronized boolean isValid() {
            return this.valid;
        }

        public synchronized long getTtl() {
            return this.ttl;
        }
    }

    public static enum MatState {
        NEEDS_LOADING,
        LOADING,
        FAILED_LOAD,
        LOADED;

    }
}

