/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.xquery.saxon;

import java.io.IOException;
import java.io.Writer;
import java.sql.SQLXML;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import net.sf.saxon.AugmentedSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.PathMap;
import net.sf.saxon.expr.RootExpression;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.query.DynamicQueryContext;
import net.sf.saxon.query.QueryResult;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.sxpath.IndependentContext;
import net.sf.saxon.sxpath.XPathEvaluator;
import net.sf.saxon.sxpath.XPathExpression;
import net.sf.saxon.sxpath.XPathStaticContext;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.SequenceType;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.SQLXMLImpl;
import org.teiid.core.types.XMLTranslator;
import org.teiid.core.types.XMLType;
import org.teiid.query.QueryPlugin;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.function.source.XMLSystemFunctions;
import org.teiid.query.processor.xml.XMLUtil;
import org.teiid.query.sql.lang.XMLTable;
import org.teiid.query.sql.symbol.DerivedColumn;
import org.teiid.query.sql.symbol.XMLNamespaces;
import org.teiid.query.xquery.saxon.PathMapFilter;
import org.teiid.translator.WSConnection;

public class SaxonXQueryExpression {
    private static final Expression DUMMY_EXPRESSION = new Expression(){

        public ItemType getItemType(TypeHierarchy th) {
            return null;
        }

        public void explain(ExpressionPresenter out) {
        }

        public Expression copy() {
            return null;
        }

        protected int computeCardinality() {
            return 0;
        }

        public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
            return pathMapNodeSet;
        }
    };
    private static final ErrorListener ERROR_LISTENER = new ErrorListener(){

        @Override
        public void warning(TransformerException arg0) throws TransformerException {
        }

        @Override
        public void error(TransformerException arg0) throws TransformerException {
        }

        @Override
        public void fatalError(TransformerException arg0) throws TransformerException {
        }
    };
    private XQueryExpression xQuery;
    private Configuration config = new Configuration();
    private PathMap.PathMapRoot contextRoot;

    public SaxonXQueryExpression(String xQueryString, XMLNamespaces namespaces, List<DerivedColumn> passing, List<XMLTable.XMLColumn> columns) throws QueryResolverException {
        this.config.setErrorListener(ERROR_LISTENER);
        StaticQueryContext context = new StaticQueryContext(this.config);
        IndependentContext ic = new IndependentContext(this.config);
        if (namespaces != null) {
            for (XMLNamespaces.NamespaceItem item : namespaces.getNamespaceItems()) {
                if (item.getPrefix() == null) {
                    if (item.getUri() == null) {
                        context.setDefaultElementNamespace("");
                        ic.setDefaultElementNamespace("");
                        continue;
                    }
                    context.setDefaultElementNamespace(item.getUri());
                    ic.setDefaultElementNamespace(item.getUri());
                    continue;
                }
                context.declareNamespace(item.getPrefix(), item.getUri());
                ic.declareNamespace(item.getPrefix(), item.getUri());
            }
        }
        for (DerivedColumn derivedColumn : passing) {
            if (derivedColumn.getAlias() == null) continue;
            try {
                context.declareGlobalVariable(StructuredQName.fromClarkName((String)derivedColumn.getAlias()), SequenceType.ANY_SEQUENCE, null, true);
            }
            catch (XPathException e) {
                throw new TeiidRuntimeException((Throwable)e, "Could not define global variable");
            }
        }
        this.processColumns(columns, ic);
        try {
            this.xQuery = context.compileQuery(xQueryString);
        }
        catch (XPathException e) {
            throw new QueryResolverException(e, QueryPlugin.Util.getString("SaxonXQueryExpression.compile_failed"));
        }
    }

    private SaxonXQueryExpression() {
    }

    public SaxonXQueryExpression clone() {
        SaxonXQueryExpression clone = new SaxonXQueryExpression();
        clone.xQuery = this.xQuery;
        clone.config = this.config;
        clone.contextRoot = this.contextRoot;
        return clone;
    }

    public boolean usesContextItem() {
        return this.xQuery.usesContextItem();
    }

    public void useDocumentProjection(List<XMLTable.XMLColumn> columns, AnalysisRecord record) {
        PathMap.PathMapRoot parentRoot;
        this.contextRoot = null;
        PathMap map = this.xQuery.getPathMap();
        try {
            parentRoot = map.getContextRoot();
        }
        catch (IllegalStateException e) {
            if (record.recordDebug()) {
                record.println("Document projection will not be used, since multiple context item exist.");
            }
            return;
        }
        if (parentRoot == null) {
            if (record.recordDebug()) {
                record.println("Document projection will not be used, since no context item reference was found in the XQuery");
            }
            return;
        }
        HashSet<PathMap.PathMapNode> finalNodes = new HashSet<PathMap.PathMapNode>();
        this.getReturnableNodes((PathMap.PathMapNode)parentRoot, finalNodes);
        if (!finalNodes.isEmpty()) {
            if (columns != null && !columns.isEmpty()) {
                if (finalNodes.size() != 1) {
                    if (record.recordDebug()) {
                        record.println("Document projection will not be used, since multiple return items exist");
                    }
                    return;
                }
                if ((parentRoot = this.projectColumns(parentRoot, columns, finalNodes.iterator().next(), record)) == null) {
                    return;
                }
            } else {
                for (PathMap.PathMapNode subNode : finalNodes) {
                    subNode.createArc(new AxisExpression(5, (NodeTest)AnyNodeTest.getInstance()));
                }
            }
        }
        if (parentRoot.hasUnknownDependencies()) {
            if (record.recordDebug()) {
                record.println("Document projection will not be used since there are unknown dependencies (most likely a user defined function).");
            }
            return;
        }
        if (record.recordDebug()) {
            StringBuilder sb = new StringBuilder();
            SaxonXQueryExpression.showArcs(sb, (PathMap.PathMapNode)parentRoot, 0);
            record.println("Using path filtering for XQuery context item: \n" + sb.toString());
        }
        this.contextRoot = parentRoot;
    }

    private PathMap.PathMapRoot projectColumns(PathMap.PathMapRoot parentRoot, List<XMLTable.XMLColumn> columns, PathMap.PathMapNode finalNode, AnalysisRecord record) {
        for (XMLTable.XMLColumn xmlColumn : columns) {
            if (xmlColumn.isOrdinal()) continue;
            Expression internalExpression = xmlColumn.getPathExpression().getInternalExpression();
            PathMap subMap = new PathMap(internalExpression);
            PathMap.PathMapRoot subContextRoot = null;
            for (PathMap.PathMapRoot pathMapRoot : subMap.getPathMapRoots()) {
                if (!(pathMapRoot.getRootExpression() instanceof ContextItemExpression) && !(pathMapRoot.getRootExpression() instanceof RootExpression)) continue;
                if (subContextRoot != null) {
                    if (record.recordDebug()) {
                        record.println("Document projection will not be used, since multiple context item exist in column path " + xmlColumn.getPath());
                    }
                    return null;
                }
                subContextRoot = pathMapRoot;
            }
            if (subContextRoot == null) {
                if (!(internalExpression instanceof ContextItemExpression)) continue;
                this.addReturnedArcs(xmlColumn, finalNode);
                continue;
            }
            for (PathMap.PathMapRoot pathMapRoot : subContextRoot.getArcs()) {
                finalNode.createArc(pathMapRoot.getStep(), pathMapRoot.getTarget());
            }
            HashSet<PathMap.PathMapNode> subFinalNodes = new HashSet<PathMap.PathMapNode>();
            this.getReturnableNodes((PathMap.PathMapNode)subContextRoot, subFinalNodes);
            for (PathMap.PathMapNode subNode : subFinalNodes) {
                this.addReturnedArcs(xmlColumn, subNode);
            }
        }
        PathMap newMap = new PathMap(DUMMY_EXPRESSION);
        PathMap.PathMapRoot newRoot = newMap.makeNewRoot(parentRoot.getRootExpression());
        if (parentRoot.isAtomized()) {
            newRoot.setAtomized();
        }
        if (parentRoot.isReturnable()) {
            newRoot.setReturnable(true);
        }
        if (parentRoot.hasUnknownDependencies()) {
            newRoot.setHasUnknownDependencies();
        }
        for (PathMap.PathMapArc arc : parentRoot.getArcs()) {
            newRoot.createArc(arc.getStep(), arc.getTarget());
        }
        return newMap.reduceToDownwardsAxes(newRoot);
    }

    private void addReturnedArcs(XMLTable.XMLColumn xmlColumn, PathMap.PathMapNode subNode) {
        if (xmlColumn.getSymbol().getType() == DataTypeManager.DefaultDataClasses.XML) {
            subNode.createArc(new AxisExpression(5, (NodeTest)AnyNodeTest.getInstance()));
        } else {
            subNode.createArc(new AxisExpression(3, (NodeTest)NodeKindTest.TEXT));
            subNode.setAtomized();
        }
    }

    private void getReturnableNodes(PathMap.PathMapNode node, HashSet<PathMap.PathMapNode> finalNodes) {
        if (node.isReturnable()) {
            finalNodes.add(node);
        }
        for (PathMap.PathMapArc arc : node.getArcs()) {
            this.getReturnableNodes(arc.getTarget(), finalNodes);
        }
    }

    private void processColumns(List<XMLTable.XMLColumn> columns, IndependentContext ic) throws QueryResolverException {
        if (columns == null) {
            return;
        }
        XPathEvaluator eval = new XPathEvaluator(this.config);
        eval.setStaticContext((XPathStaticContext)ic);
        for (XMLTable.XMLColumn xmlColumn : columns) {
            XPathExpression exp;
            if (xmlColumn.isOrdinal()) continue;
            String path = xmlColumn.getPath();
            if (path == null) {
                path = xmlColumn.getName();
            }
            if ((path = path.trim()).startsWith("/")) {
                path = path.startsWith("//") ? '.' + path : path.substring(1);
            }
            try {
                exp = eval.createExpression(path);
            }
            catch (XPathException e) {
                throw new QueryResolverException(e, QueryPlugin.Util.getString("SaxonXQueryExpression.invalid_path", new Object[]{xmlColumn.getName(), xmlColumn.getPath()}));
            }
            xmlColumn.setPathExpression(exp);
        }
    }

    public Result evaluateXQuery(Object context, Map<String, Object> parameterValues) throws TeiidProcessingException {
        DynamicQueryContext dynamicContext = new DynamicQueryContext(this.config);
        Result result = new Result();
        try {
            Object source;
            try {
                for (Map.Entry<String, Object> entry : parameterValues.entrySet()) {
                    Object value = entry.getValue();
                    if (value instanceof SQLXML) {
                        value = XMLSystemFunctions.convertToSource(value);
                        result.sources.add((Source)value);
                    } else if (value instanceof Date) {
                        value = XMLSystemFunctions.convertToAtomicValue(value);
                    }
                    dynamicContext.setParameter(entry.getKey(), value);
                }
            }
            catch (TransformerException e) {
                throw new TeiidProcessingException((Throwable)e);
            }
            if (context != null) {
                DocumentInfo doc;
                source = XMLSystemFunctions.convertToSource(context);
                result.sources.add((Source)source);
                if (this.contextRoot != null) {
                    PathMapFilter filter = new PathMapFilter(this.contextRoot);
                    AugmentedSource sourceInput = AugmentedSource.makeAugmentedSource((Source)source);
                    sourceInput.addFilter((ProxyReceiver)filter);
                    source = sourceInput;
                }
                try {
                    doc = this.config.buildDocument((Source)source);
                }
                catch (XPathException e) {
                    throw new TeiidProcessingException((Throwable)e, QueryPlugin.Util.getString("SaxonXQueryExpression.bad_context"));
                }
                dynamicContext.setContextItem((Item)doc);
            }
            try {
                result.iter = this.xQuery.iterator(dynamicContext);
                source = result;
                return source;
            }
            catch (TransformerException e) {
                throw new TeiidProcessingException((Throwable)e, QueryPlugin.Util.getString("SaxonXQueryExpression.bad_xquery"));
            }
        }
        finally {
            if (result.iter == null) {
                result.close();
            }
        }
    }

    public XMLType createXMLType(final SequenceIterator iter, BufferManager bufferManager, boolean emptyOnEmpty) throws XPathException, TeiidComponentException, TeiidProcessingException {
        Item next;
        Item item = iter.next();
        if (item == null && !emptyOnEmpty) {
            return null;
        }
        XMLType.Type type = XMLType.Type.CONTENT;
        if (item instanceof NodeInfo) {
            NodeInfo info = (NodeInfo)item;
            switch (info.getNodeKind()) {
                case 9: {
                    type = XMLType.Type.DOCUMENT;
                    break;
                }
                case 1: {
                    type = XMLType.Type.ELEMENT;
                    break;
                }
                case 3: {
                    type = XMLType.Type.TEXT;
                }
            }
        }
        if ((next = iter.next()) != null) {
            type = XMLType.Type.CONTENT;
        }
        SQLXMLImpl xml = XMLUtil.saveToBufferManager(bufferManager, new XMLTranslator(){

            public void translate(Writer writer) throws TransformerException, IOException {
                Properties props = new Properties();
                props.setProperty("method", "xml");
                props.setProperty("omit-xml-declaration", "yes");
                QueryResult.serializeSequence((SequenceIterator)iter.getAnother(), (Configuration)SaxonXQueryExpression.this.config, (Writer)writer, (Properties)props);
            }
        });
        XMLType value = new XMLType((SQLXML)xml);
        value.setType(type);
        return value;
    }

    public Configuration getConfig() {
        return this.config;
    }

    public static void showArcs(StringBuilder sb, PathMap.PathMapNode node, int level) {
        for (PathMap.PathMapArc pathMapArc : node.getArcs()) {
            char[] pad = new char[level * 2];
            Arrays.fill(pad, ' ');
            sb.append(new String(pad));
            sb.append(pathMapArc.getStep());
            sb.append('\n');
            node = pathMapArc.getTarget();
            SaxonXQueryExpression.showArcs(sb, node, level + 1);
        }
    }

    public static class Result {
        public SequenceIterator iter;
        public List<Source> sources = new LinkedList<Source>();

        public void close() {
            for (Source source : this.sources) {
                WSConnection.Util.closeSource((Source)source);
            }
            if (this.iter != null) {
                this.iter.close();
            }
            this.sources.clear();
            this.iter = null;
        }
    }
}

