/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types;

import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLXML;
import java.util.HashMap;
import java.util.Map;
import org.teiid.core.types.DataTypeManager;

public final class JDBCSQLTypeInfo {
    public static final String STRING = "string";
    public static final String BOOLEAN = "boolean";
    public static final String TIME = "time";
    public static final String DATE = "date";
    public static final String TIMESTAMP = "timestamp";
    public static final String INTEGER = "integer";
    public static final String FLOAT = "float";
    public static final String DOUBLE = "double";
    public static final String BIGDECIMAL = "bigdecimal";
    public static final String BIGINTEGER = "biginteger";
    public static final String BYTE = "byte";
    public static final String SHORT = "short";
    public static final String LONG = "long";
    public static final String CHAR = "char";
    public static final String OBJECT = "object";
    public static final String CLOB = "clob";
    public static final String BLOB = "blob";
    public static final String XML = "xml";
    public static final String NULL = "null";
    public static final String STRING_CLASS = DataTypeManager.DefaultDataClasses.STRING.getName();
    public static final String BOOLEAN_CLASS = DataTypeManager.DefaultDataClasses.BOOLEAN.getName();
    public static final String TIME_CLASS = DataTypeManager.DefaultDataClasses.TIME.getName();
    public static final String DATE_CLASS = DataTypeManager.DefaultDataClasses.DATE.getName();
    public static final String TIMESTAMP_CLASS = DataTypeManager.DefaultDataClasses.TIMESTAMP.getName();
    public static final String INTEGER_CLASS = DataTypeManager.DefaultDataClasses.INTEGER.getName();
    public static final String FLOAT_CLASS = DataTypeManager.DefaultDataClasses.FLOAT.getName();
    public static final String DOUBLE_CLASS = DataTypeManager.DefaultDataClasses.DOUBLE.getName();
    public static final String BIGDECIMAL_CLASS = DataTypeManager.DefaultDataClasses.BIG_DECIMAL.getName();
    public static final String BYTE_CLASS = DataTypeManager.DefaultDataClasses.BYTE.getName();
    public static final String SHORT_CLASS = DataTypeManager.DefaultDataClasses.SHORT.getName();
    public static final String LONG_CLASS = DataTypeManager.DefaultDataClasses.LONG.getName();
    public static final String CHAR_CLASS = DataTypeManager.DefaultDataClasses.CHAR.getName();
    public static final String BIGINTEGER_CLASS = DataTypeManager.DefaultDataClasses.BIG_INTEGER.getName();
    public static final String OBJECT_CLASS = DataTypeManager.DefaultDataClasses.OBJECT.getName();
    public static final String CLOB_CLASS = Clob.class.getName();
    public static final String BLOB_CLASS = Blob.class.getName();
    public static final String XML_CLASS = SQLXML.class.getName();
    private static Map<String, Integer> NAME_TO_TYPE_MAP = new HashMap<String, Integer>();
    private static Map<Integer, String> TYPE_TO_NAME_MAP = new HashMap<Integer, String>();
    private static Map<String, String> NAME_TO_CLASSNAME = new HashMap<String, String>();
    private static Map<String, String> CLASSNAME_TO_NAME = new HashMap<String, String>();

    private JDBCSQLTypeInfo() {
    }

    private static void addTypeMapping(String typeName, String javaClass, int sqlType, int ... secondaryTypes) {
        JDBCSQLTypeInfo.addTypeMapping(typeName, javaClass, sqlType, true);
        for (int type : secondaryTypes) {
            TYPE_TO_NAME_MAP.put(type, typeName);
        }
    }

    private static void addTypeMapping(String typeName, String javaClass, int sqlType, boolean preferedType) {
        NAME_TO_TYPE_MAP.put(typeName, sqlType);
        if (preferedType) {
            TYPE_TO_NAME_MAP.put(sqlType, typeName);
        }
        if (javaClass != null) {
            NAME_TO_CLASSNAME.put(typeName, javaClass);
            CLASSNAME_TO_NAME.put(javaClass, typeName);
        }
    }

    public static final int getSQLType(String typeName) {
        if (typeName == null) {
            return 0;
        }
        Integer sqlType = NAME_TO_TYPE_MAP.get(typeName);
        if (sqlType == null) {
            return 2000;
        }
        return sqlType;
    }

    public static final int getSQLTypeFromClass(String className) {
        if (className == null) {
            return 0;
        }
        String name = CLASSNAME_TO_NAME.get(className);
        if (name == null) {
            return 2000;
        }
        return JDBCSQLTypeInfo.getSQLType(name);
    }

    public static final int getSQLTypeFromRuntimeType(Class<?> type) {
        if (type == null) {
            return 0;
        }
        String name = DataTypeManager.getDataTypeName(type);
        if (name == null) {
            return 2000;
        }
        return JDBCSQLTypeInfo.getSQLType(name);
    }

    public static final String getJavaClassName(int jdbcSQLType) {
        String className = NAME_TO_CLASSNAME.get(JDBCSQLTypeInfo.getTypeName(jdbcSQLType));
        if (className == null) {
            return OBJECT_CLASS;
        }
        return className;
    }

    public static final String getTypeName(int sqlType) {
        String name = TYPE_TO_NAME_MAP.get(sqlType);
        if (name == null) {
            return OBJECT;
        }
        return name;
    }

    public static String[] getMMTypeNames() {
        return new String[]{STRING, BOOLEAN, TIME, DATE, TIMESTAMP, INTEGER, FLOAT, DOUBLE, BIGDECIMAL, BIGINTEGER, BYTE, SHORT, LONG, CHAR, OBJECT, CLOB, BLOB, XML};
    }

    static {
        JDBCSQLTypeInfo.addTypeMapping(STRING, STRING_CLASS, 12, -1, 1);
        JDBCSQLTypeInfo.addTypeMapping(CHAR, CHAR_CLASS, 1, false);
        JDBCSQLTypeInfo.addTypeMapping(BOOLEAN, BOOLEAN_CLASS, -7, new int[0]);
        JDBCSQLTypeInfo.addTypeMapping(TIME, TIME_CLASS, 92, new int[0]);
        JDBCSQLTypeInfo.addTypeMapping(DATE, DATE_CLASS, 91, new int[0]);
        JDBCSQLTypeInfo.addTypeMapping(TIMESTAMP, TIMESTAMP_CLASS, 93, new int[0]);
        JDBCSQLTypeInfo.addTypeMapping(INTEGER, INTEGER_CLASS, 4, new int[0]);
        JDBCSQLTypeInfo.addTypeMapping(FLOAT, FLOAT_CLASS, 7, new int[0]);
        JDBCSQLTypeInfo.addTypeMapping(DOUBLE, DOUBLE_CLASS, 8, 6);
        JDBCSQLTypeInfo.addTypeMapping(BIGDECIMAL, BIGDECIMAL_CLASS, 2, 3);
        JDBCSQLTypeInfo.addTypeMapping(BIGINTEGER, BIGINTEGER_CLASS, 2, false);
        JDBCSQLTypeInfo.addTypeMapping(BYTE, BYTE_CLASS, -6, new int[0]);
        JDBCSQLTypeInfo.addTypeMapping(SHORT, SHORT_CLASS, 5, new int[0]);
        JDBCSQLTypeInfo.addTypeMapping(LONG, LONG_CLASS, -5, new int[0]);
        JDBCSQLTypeInfo.addTypeMapping(OBJECT, OBJECT_CLASS, 2000, new int[0]);
        JDBCSQLTypeInfo.addTypeMapping(CLOB, CLOB_CLASS, 2005, new int[0]);
        JDBCSQLTypeInfo.addTypeMapping(BLOB, BLOB_CLASS, 2004, -2, -3, -4);
        JDBCSQLTypeInfo.addTypeMapping(NULL, null, 0, new int[0]);
        JDBCSQLTypeInfo.addTypeMapping(XML, XML_CLASS, 2009, new int[0]);
        TYPE_TO_NAME_MAP.put(-9, STRING);
        TYPE_TO_NAME_MAP.put(-16, STRING);
        TYPE_TO_NAME_MAP.put(-15, CHAR);
        TYPE_TO_NAME_MAP.put(2011, CLOB);
    }
}

