/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.base;

import java.util.Map;
import java.util.UUID;
import net.jcip.annotations.NotThreadSafe;
import org.modeshape.graph.connector.base.MapNode;
import org.modeshape.graph.connector.base.MapWorkspace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class StandardMapWorkspace<NodeType extends MapNode>
extends MapWorkspace<NodeType> {
    private final Map<UUID, NodeType> nodesByUuid;

    public StandardMapWorkspace(String name, Map<UUID, NodeType> nodesByUuid, NodeType rootNode) {
        super(name, rootNode);
        this.nodesByUuid = nodesByUuid;
        UUID rootNodeUuid = ((MapNode)rootNode).getUuid();
        if (!this.nodesByUuid.containsKey(rootNodeUuid)) {
            this.nodesByUuid.put(rootNodeUuid, rootNode);
        }
        assert (this.nodesByUuid != null);
    }

    public StandardMapWorkspace(String name, Map<UUID, NodeType> nodesByUuid, StandardMapWorkspace<NodeType> originalToClone) {
        super(name, originalToClone);
        this.nodesByUuid = nodesByUuid;
        this.nodesByUuid.putAll(originalToClone.nodesByUuid);
        assert (this.nodesByUuid != null);
    }

    @Override
    public NodeType getNode(UUID uuid) {
        return (NodeType)((MapNode)this.nodesByUuid.get(uuid));
    }

    @Override
    public NodeType putNode(NodeType node) {
        return (NodeType)((MapNode)this.nodesByUuid.put(((MapNode)node).getUuid(), node));
    }

    @Override
    public NodeType removeNode(UUID uuid) {
        return (NodeType)(this.rootNodeUuid.equals(uuid) ? null : (MapNode)this.nodesByUuid.remove(uuid));
    }

    @Override
    public void removeAll() {
        MapNode newRootNode = ((MapNode)this.getRootNode()).withoutChildren().withoutProperties().freeze();
        this.nodesByUuid.clear();
        this.nodesByUuid.put(newRootNode.getUuid(), newRootNode);
    }
}

