/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.federation;

import java.util.Iterator;
import java.util.List;
import net.jcip.annotations.Immutable;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Location;
import org.modeshape.graph.connector.federation.ProjectedNode;
import org.modeshape.graph.connector.federation.Projection;
import org.modeshape.graph.connector.federation.ProjectorWithPlaceholders;
import org.modeshape.graph.connector.federation.ProxyNode;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class BranchedMirrorProjector
extends ProjectorWithPlaceholders {
    private final Projection mirrorProjection;
    private final Projection branchProjection;
    private final Path branchFederatedPath;
    private final Path branchSourcePath;
    private final boolean branchSourceUsesSamePath;

    static BranchedMirrorProjector with(ExecutionContext context, List<Projection> projections) {
        assert (projections != null);
        assert (context != null);
        if (projections.size() != 2) {
            return null;
        }
        Projection first = projections.get(0);
        Projection second = projections.get(1);
        if (first.getRules().size() != 1) {
            return null;
        }
        if (second.getRules().size() != 1) {
            return null;
        }
        Projection.Rule firstRule = first.getRules().get(0);
        Projection.Rule secondRule = second.getRules().get(0);
        assert (firstRule != null);
        assert (secondRule != null);
        PathFactory pathFactory = context.getValueFactories().getPathFactory();
        List<Path> firstTopLevelPaths = first.getRules().get(0).getTopLevelPathsInRepository(pathFactory);
        if (firstTopLevelPaths.size() != 1) {
            return null;
        }
        List<Path> secondTopLevelPaths = second.getRules().get(0).getTopLevelPathsInRepository(pathFactory);
        if (secondTopLevelPaths.size() != 1) {
            return null;
        }
        Path firstTopLevelPath = firstTopLevelPaths.get(0);
        Path secondTopLevelPath = secondTopLevelPaths.get(0);
        if (firstTopLevelPath.isRoot()) {
            return new BranchedMirrorProjector(context, projections, first, second, secondTopLevelPath, secondRule.getPathInSource(secondTopLevelPath, pathFactory));
        }
        if (!secondTopLevelPath.isRoot()) {
            return null;
        }
        return new BranchedMirrorProjector(context, projections, second, first, firstTopLevelPath, firstRule.getPathInSource(firstTopLevelPath, pathFactory));
    }

    BranchedMirrorProjector(ExecutionContext context, List<Projection> projections, Projection mirrorProjection, Projection branchProjection, Path branchFederatedPath, Path branchSourcePath) {
        super(context, projections);
        assert (mirrorProjection != null);
        assert (branchProjection != null);
        assert (branchFederatedPath != null);
        assert (branchSourcePath != null);
        this.mirrorProjection = mirrorProjection;
        this.branchProjection = branchProjection;
        this.branchFederatedPath = branchFederatedPath;
        this.branchSourcePath = branchSourcePath;
        this.branchSourceUsesSamePath = branchSourcePath.equals(branchFederatedPath);
    }

    @Override
    public ProjectedNode project(ExecutionContext context, Location location, boolean requiresUpdate) {
        assert (location != null);
        if (location.hasPath()) {
            Path path = location.getPath();
            if (path.isRoot()) {
                if (requiresUpdate && this.mirrorProjection.isReadOnly()) {
                    return null;
                }
                ProxyNode result = new ProxyNode(this.mirrorProjection, location, location.with(this.branchSourcePath), this.branchSourceUsesSamePath);
                result.add(this.isPlaceholder(location));
                return result;
            }
            ProjectedNode onBranch = this.isOnBranch(path, location, context);
            if (onBranch != null) {
                if (requiresUpdate && this.branchProjection.isReadOnly()) {
                    return null;
                }
                return onBranch;
            }
            if (requiresUpdate && this.mirrorProjection.isReadOnly()) {
                return null;
            }
            return new ProxyNode(this.mirrorProjection, location, location, true);
        }
        if (requiresUpdate) {
            if (this.branchProjection.isReadOnly()) {
                if (this.mirrorProjection.isReadOnly()) {
                    return null;
                }
                return new ProxyNode(this.mirrorProjection, location, location, true);
            }
            if (this.mirrorProjection.isReadOnly()) {
                return new ProxyNode(this.branchProjection, location, location, this.branchSourceUsesSamePath);
            }
        }
        ProxyNode result = new ProxyNode(this.mirrorProjection, location, location, true);
        result.add(new ProxyNode(this.branchProjection, location, location, this.branchSourceUsesSamePath));
        return result;
    }

    protected final ProjectedNode isOnBranch(Path federatedPath, Location location, ExecutionContext context) {
        Iterator<Path.Segment> branchIter = this.branchFederatedPath.iterator();
        Iterator<Path.Segment> federIter = federatedPath.iterator();
        if (branchIter.hasNext() && federIter.hasNext() && !branchIter.next().equals(federIter.next())) {
            return null;
        }
        while (branchIter.hasNext() && federIter.hasNext()) {
            if (branchIter.next().equals(federIter.next())) continue;
            return null;
        }
        if (branchIter.hasNext()) {
            return this.isPlaceholder(location);
        }
        Location locationInSource = location;
        if (!this.branchSourceUsesSamePath) {
            if (federIter.hasNext()) {
                Path subpath = federatedPath.subpath(this.branchFederatedPath.size());
                Path sourcePath = context.getValueFactories().getPathFactory().create(this.branchSourcePath, subpath);
                locationInSource = location.with(sourcePath);
            } else {
                locationInSource = location.with(this.branchSourcePath);
            }
        }
        return new ProxyNode(this.branchProjection, locationInSource, location, this.branchSourceUsesSamePath);
    }
}

