/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.path;

import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.jcip.annotations.ThreadSafe;
import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.connector.RepositoryContext;
import org.modeshape.graph.connector.path.PathRepositorySource;
import org.modeshape.graph.connector.path.PathRepositoryTransaction;
import org.modeshape.graph.connector.path.PathRequestProcessor;
import org.modeshape.graph.connector.path.PathWorkspace;
import org.modeshape.graph.observe.Observer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public abstract class PathRepository {
    protected final UUID rootNodeUuid;
    private final String sourceName;
    private final String defaultWorkspaceName;
    protected final ConcurrentMap<String, PathWorkspace> workspaces = new ConcurrentHashMap<String, PathWorkspace>();

    protected PathRepository(PathRepositorySource source) {
        CheckArg.isNotNull((Object)source, (String)"source");
        CheckArg.isNotEmpty((String)source.getName(), (String)"source.name");
        CheckArg.isNotNull((Object)source.getRootNodeUuid(), (String)"source.rootNodeUUID");
        this.rootNodeUuid = source.getRootNodeUuid();
        this.sourceName = source.getName();
        this.defaultWorkspaceName = source.getDefaultWorkspaceName() != null ? source.getDefaultWorkspaceName() : "";
    }

    public final UUID getRootNodeUuid() {
        return this.rootNodeUuid;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    protected String getDefaultWorkspaceName() {
        return this.defaultWorkspaceName;
    }

    public Set<String> getWorkspaceNames() {
        return this.workspaces.keySet();
    }

    public PathWorkspace getWorkspace(String name) {
        if (name == null) {
            name = this.defaultWorkspaceName;
        }
        return (PathWorkspace)this.workspaces.get(name);
    }

    protected abstract void initialize();

    public boolean isWritable() {
        return false;
    }

    PathRequestProcessor createRequestProcessor(ExecutionContext context, PathRepositorySource source) {
        RepositoryContext repositoryContext = source.getRepositoryContext();
        Observer observer = repositoryContext != null ? repositoryContext.getObserver() : null;
        boolean updatesAllowed = source.areUpdatesAllowed();
        PathRepositoryTransaction txn = new PathRepositoryTransaction(){

            public void commit() {
            }

            public void rollback() {
            }
        };
        return new PathRequestProcessor(context, this, observer, updatesAllowed, txn);
    }
}

