/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.xmlfile;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.concurrent.atomic.AtomicInteger;
import javax.naming.BinaryRefAddr;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.modeshape.common.annotation.Category;
import org.modeshape.common.annotation.Description;
import org.modeshape.common.annotation.Label;
import org.modeshape.common.annotation.ReadOnly;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.Subgraph;
import org.modeshape.graph.connector.RepositoryConnection;
import org.modeshape.graph.connector.RepositoryConnectionFactory;
import org.modeshape.graph.connector.RepositoryContext;
import org.modeshape.graph.connector.RepositorySource;
import org.modeshape.graph.connector.RepositorySourceCapabilities;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.connector.inmemory.InMemoryRepositorySource;
import org.modeshape.graph.observe.Observer;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class XmlFileRepositorySource
implements RepositorySource,
ObjectFactory {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_RETRY_LIMIT = 0;
    public static final String DEFAULT_WORKSPACE_NAME = "";
    protected static final RepositorySourceCapabilities CAPABILITIES = new RepositorySourceCapabilities(true, false, false, false, true);
    protected static final String CONTENT_ATTR = "content";
    protected static final String SOURCE_NAME_ATTR = "sourceName";
    protected static final String DEFAULT_WORKSPACE_NAME_ATTR = "defaultWorkspaceName";
    protected static final String RETRY_LIMIT_ATTR = "retryLimit";
    @Description(i18n=GraphI18n.class, value="namePropertyDescription")
    @Label(i18n=GraphI18n.class, value="namePropertyLabel")
    @Category(i18n=GraphI18n.class, value="namePropertyCategory")
    @GuardedBy(value="sourcesLock")
    private String name;
    @Description(i18n=GraphI18n.class, value="contentPropertyDescription")
    @Label(i18n=GraphI18n.class, value="contentPropertyLabel")
    @Category(i18n=GraphI18n.class, value="contentPropertyCategory")
    @GuardedBy(value="this")
    private String content;
    @Description(i18n=GraphI18n.class, value="defaultWorkspaceNamePropertyDescription")
    @Label(i18n=GraphI18n.class, value="defaultWorkspaceNamePropertyLabel")
    @Category(i18n=GraphI18n.class, value="defaultWorkspaceNamePropertyCategory")
    private String defaultWorkspaceName = "";
    @Description(i18n=GraphI18n.class, value="retryLimitPropertyDescription")
    @Label(i18n=GraphI18n.class, value="retryLimitPropertyLabel")
    @Category(i18n=GraphI18n.class, value="retryLimitPropertyCategory")
    private final AtomicInteger retryLimit = new AtomicInteger(0);
    private transient InMemoryRepositorySource inMemorySource;
    private transient ExecutionContext defaultContext = new ExecutionContext();
    private transient RepositoryContext repositoryContext = new DefaultRepositoryContext();

    @Override
    public void initialize(RepositoryContext context) throws RepositorySourceException {
        this.repositoryContext = context != null ? context : new DefaultRepositoryContext();
    }

    public RepositoryContext getRepositoryContext() {
        return this.repositoryContext;
    }

    @Override
    public int getRetryLimit() {
        return this.retryLimit.get();
    }

    @Override
    public void setRetryLimit(int limit) {
        this.retryLimit.set(limit < 0 ? 0 : limit);
    }

    public String getDefaultWorkspaceName() {
        return this.defaultWorkspaceName;
    }

    public void setDefaultWorkspaceName(String defaultWorkspaceName) {
        this.defaultWorkspaceName = defaultWorkspaceName != null ? defaultWorkspaceName : DEFAULT_WORKSPACE_NAME;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getContentLocation() {
        return this.content;
    }

    public void setContentLocation(String uriOrFilePathOrResourcePath) {
        this.content = uriOrFilePathOrResourcePath;
    }

    @Override
    public synchronized RepositoryConnection getConnection() throws RepositorySourceException {
        if (this.inMemorySource == null) {
            this.inMemorySource = new InMemoryRepositorySource();
            this.inMemorySource.setName(this.name);
            if (this.content != null && this.content.length() != 0) {
                try {
                    ExecutionContext context = this.repositoryContext != null ? this.repositoryContext.getExecutionContext() : this.defaultContext;
                    Graph graph = Graph.create(this.inMemorySource, context);
                    graph.useWorkspace(this.defaultWorkspaceName);
                    graph.importXmlFrom(this.content).into("/");
                }
                catch (IOException e) {
                    this.inMemorySource = null;
                    throw new RepositorySourceException(this.getName(), e);
                }
                catch (SAXException e) {
                    this.inMemorySource = null;
                    throw new RepositorySourceException(this.getName(), e);
                }
                catch (RepositorySourceException e) {
                    this.inMemorySource = null;
                    throw e;
                }
                catch (RuntimeException e) {
                    this.inMemorySource = null;
                    throw e;
                }
            }
        }
        return this.inMemorySource.getConnection();
    }

    @Override
    public synchronized void close() {
        this.inMemorySource = null;
    }

    @Override
    public synchronized Reference getReference() {
        String className = this.getClass().getName();
        String factoryClassName = this.getClass().getName();
        Reference ref = new Reference(className, factoryClassName, null);
        if (this.getName() != null) {
            ref.add(new StringRefAddr(SOURCE_NAME_ATTR, this.getName()));
        }
        if (this.getContentLocation() != null) {
            ref.add(new StringRefAddr(CONTENT_ATTR, this.getContentLocation().toString()));
        }
        if (this.getDefaultWorkspaceName() != null) {
            ref.add(new StringRefAddr(DEFAULT_WORKSPACE_NAME_ATTR, this.getDefaultWorkspaceName()));
        }
        ref.add(new StringRefAddr(RETRY_LIMIT_ATTR, Integer.toString(this.getRetryLimit())));
        return ref;
    }

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        if (obj instanceof Reference) {
            HashMap<String, Object> values = new HashMap<String, Object>();
            Reference ref = (Reference)obj;
            Enumeration<RefAddr> en = ref.getAll();
            while (en.hasMoreElements()) {
                Object value;
                String key;
                RefAddr subref = en.nextElement();
                if (subref instanceof StringRefAddr) {
                    key = subref.getType();
                    value = subref.getContent();
                    if (value == null) continue;
                    values.put(key, value.toString());
                    continue;
                }
                if (!(subref instanceof BinaryRefAddr)) continue;
                key = subref.getType();
                value = subref.getContent();
                if (!(value instanceof byte[])) continue;
                ByteArrayInputStream bais = new ByteArrayInputStream((byte[])value);
                ObjectInputStream ois = new ObjectInputStream(bais);
                value = ois.readObject();
                values.put(key, value);
            }
            String sourceName = (String)values.get(SOURCE_NAME_ATTR);
            String contentLocation = (String)values.get(CONTENT_ATTR);
            String defaultWorkspaceName = (String)values.get(DEFAULT_WORKSPACE_NAME_ATTR);
            String retryLimit = (String)values.get(RETRY_LIMIT_ATTR);
            XmlFileRepositorySource source = new XmlFileRepositorySource();
            if (sourceName != null) {
                source.setName(sourceName);
            }
            if (contentLocation != null) {
                source.setContentLocation(contentLocation);
            }
            if (defaultWorkspaceName != null) {
                source.setDefaultWorkspaceName(defaultWorkspaceName);
            }
            if (retryLimit != null) {
                source.setRetryLimit(Integer.parseInt(retryLimit));
            }
            return source;
        }
        return null;
    }

    @Override
    public RepositorySourceCapabilities getCapabilities() {
        return CAPABILITIES;
    }

    @Description(i18n=GraphI18n.class, value="updatesAllowedPropertyDescription")
    @Label(i18n=GraphI18n.class, value="updatesAllowedPropertyLabel")
    @Category(i18n=GraphI18n.class, value="updatesAllowedPropertyCategory")
    @ReadOnly
    public boolean areUpdatesAllowed() {
        return this.getCapabilities().supportsUpdates();
    }

    public String toString() {
        return "The \"" + this.name + "\" XML file repository";
    }

    protected class DefaultRepositoryContext
    implements RepositoryContext {
        protected DefaultRepositoryContext() {
        }

        public ExecutionContext getExecutionContext() {
            return XmlFileRepositorySource.this.defaultContext;
        }

        public Subgraph getConfiguration(int depth) {
            return null;
        }

        public Observer getObserver() {
            return null;
        }

        public RepositoryConnectionFactory getRepositoryConnectionFactory() {
            return null;
        }
    }
}

