/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.property.basic;

import net.jcip.annotations.Immutable;
import org.modeshape.common.text.TextEncoder;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.HashCode;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;

@Immutable
public class BasicName
implements Name {
    private static final long serialVersionUID = -1737537720336990144L;
    private final String namespaceUri;
    private final String localName;
    private final int hc;

    private String trimNonEmptyStrings(String value) {
        if (value == null) {
            return null;
        }
        String trimmed = value.trim();
        return trimmed.length() == 0 ? value : trimmed;
    }

    public BasicName(String namespaceUri, String localName) {
        CheckArg.isNotNull((Object)localName, (String)"localName");
        this.namespaceUri = namespaceUri != null ? namespaceUri.trim().intern() : "";
        this.localName = this.trimNonEmptyStrings(localName);
        this.hc = HashCode.compute((Object[])new Object[]{this.namespaceUri, this.localName});
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    public String getString() {
        return this.getString(Path.DEFAULT_ENCODER);
    }

    public String getString(TextEncoder encoder) {
        if (this.getNamespaceUri().length() == 0) {
            if (this.getLocalName().equals(".")) {
                return ".";
            }
            if (this.getLocalName().equals("..")) {
                return "..";
            }
        }
        if (encoder == null) {
            encoder = Path.DEFAULT_ENCODER;
        }
        if (this.namespaceUri.length() > 0) {
            return "{" + encoder.encode(this.namespaceUri) + "}" + encoder.encode(this.localName);
        }
        return encoder.encode(this.localName);
    }

    public String getString(NamespaceRegistry namespaceRegistry) {
        CheckArg.isNotNull((Object)namespaceRegistry, (String)"namespaceRegistry");
        String prefix = namespaceRegistry.getPrefixForNamespaceUri(this.namespaceUri, true);
        if (prefix != null && prefix.length() != 0) {
            return prefix + ":" + this.localName;
        }
        return this.localName;
    }

    public String getString(NamespaceRegistry namespaceRegistry, TextEncoder encoder) {
        CheckArg.isNotNull((Object)namespaceRegistry, (String)"namespaceRegistry");
        String prefix = namespaceRegistry.getPrefixForNamespaceUri(this.namespaceUri, true);
        if (prefix != null && prefix.length() != 0) {
            return encoder.encode(prefix) + ":" + encoder.encode(this.localName);
        }
        return encoder.encode(this.localName);
    }

    public String getString(NamespaceRegistry namespaceRegistry, TextEncoder encoder, TextEncoder delimiterEncoder) {
        String prefix;
        if (namespaceRegistry == null) {
            if (this.getNamespaceUri().length() == 0) {
                if (this.getLocalName().equals(".")) {
                    return ".";
                }
                if (this.getLocalName().equals("..")) {
                    return "..";
                }
            }
            if (encoder == null) {
                encoder = Path.DEFAULT_ENCODER;
            }
            if (delimiterEncoder != null) {
                return delimiterEncoder.encode("{") + encoder.encode(this.namespaceUri) + delimiterEncoder.encode("}") + encoder.encode(this.localName);
            }
            return "{" + encoder.encode(this.namespaceUri) + "}" + encoder.encode(this.localName);
        }
        if (encoder == null) {
            encoder = Path.DEFAULT_ENCODER;
        }
        if ((prefix = namespaceRegistry.getPrefixForNamespaceUri(this.namespaceUri, true)) != null && prefix.length() != 0) {
            String delim = delimiterEncoder != null ? delimiterEncoder.encode(":") : ":";
            return encoder.encode(prefix) + delim + encoder.encode(this.localName);
        }
        return encoder.encode(this.localName);
    }

    public int compareTo(Name that) {
        if (that == this) {
            return 0;
        }
        int diff = this.getLocalName().compareTo(that.getLocalName());
        if (diff != 0) {
            return diff;
        }
        diff = this.getNamespaceUri().compareTo(that.getNamespaceUri());
        return diff;
    }

    public int hashCode() {
        return this.hc;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Name) {
            Name that = (Name)obj;
            if (!this.getLocalName().equals(that.getLocalName())) {
                return false;
            }
            return this.getNamespaceUri().equals(that.getNamespaceUri());
        }
        return false;
    }

    public String toString() {
        return "{" + this.namespaceUri + "}" + this.localName;
    }
}

