/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.optimize;

import java.util.LinkedList;
import net.jcip.annotations.Immutable;
import org.modeshape.graph.query.QueryContext;
import org.modeshape.graph.query.model.JoinType;
import org.modeshape.graph.query.optimize.OptimizerRule;
import org.modeshape.graph.query.plan.PlanNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class RightOuterToLeftOuterJoins
implements OptimizerRule {
    public static final RightOuterToLeftOuterJoins INSTANCE = new RightOuterToLeftOuterJoins();

    @Override
    public PlanNode execute(QueryContext context, PlanNode plan, LinkedList<OptimizerRule> ruleStack) {
        for (PlanNode joinNode : plan.findAllAtOrBelow(PlanNode.Type.JOIN)) {
            if (JoinType.RIGHT_OUTER != joinNode.getProperty(PlanNode.Property.JOIN_TYPE, JoinType.class)) continue;
            PlanNode left = joinNode.getFirstChild();
            left.removeFromParent();
            left.setParent(joinNode);
            joinNode.setProperty(PlanNode.Property.JOIN_TYPE, JoinType.LEFT_OUTER);
        }
        return plan;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

