/*
 * JBoss, Home of Professional Open Source.
 *
 * See the LEGAL.txt file distributed with this work for information regarding copyright ownership and licensing.
 *
 * See the AUTHORS.txt file distributed with this work for a full listing of individual contributors.
 */
package com.metamatrix.metamodels.wsdl.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import com.metamatrix.metamodels.wsdl.Documentation;
import com.metamatrix.metamodels.wsdl.Documented;
import com.metamatrix.metamodels.wsdl.Element;
import com.metamatrix.metamodels.wsdl.NamespaceDeclaration;
import com.metamatrix.metamodels.wsdl.WsdlPackage;

/**
 * <!-- begin-user-doc --> An implementation of the model object '<em><b>Documentation</b></em>'. <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 * <li>{@link com.metamatrix.metamodels.wsdl.impl.DocumentationImpl#getDeclaredNamespaces <em>Declared Namespaces</em>}</li>
 * <li>{@link com.metamatrix.metamodels.wsdl.impl.DocumentationImpl#getDocumentation <em>Documentation</em>}</li>
 * <li>{@link com.metamatrix.metamodels.wsdl.impl.DocumentationImpl#getElements <em>Elements</em>}</li>
 * <li>{@link com.metamatrix.metamodels.wsdl.impl.DocumentationImpl#getTextContent <em>Text Content</em>}</li>
 * <li>{@link com.metamatrix.metamodels.wsdl.impl.DocumentationImpl#getContents <em>Contents</em>}</li>
 * <li>{@link com.metamatrix.metamodels.wsdl.impl.DocumentationImpl#getDocumented <em>Documented</em>}</li>
 * </ul>
 * </p>
 * 
 * @generated
 */
public class DocumentationImpl extends EObjectImpl implements Documentation {

    /**
     * The cached value of the '{@link #getDeclaredNamespaces() <em>Declared Namespaces</em>}' containment reference list. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     * 
     * @see #getDeclaredNamespaces()
     * @generated
     * @ordered
     */
    protected EList declaredNamespaces = null;

    /**
     * The cached value of the '{@link #getDocumentation() <em>Documentation</em>}' containment reference. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * 
     * @see #getDocumentation()
     * @generated
     * @ordered
     */
    protected Documentation documentation = null;

    /**
     * The cached value of the '{@link #getElements() <em>Elements</em>}' containment reference list. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     * 
     * @see #getElements()
     * @generated
     * @ordered
     */
    protected EList elements = null;

    /**
     * The default value of the '{@link #getTextContent() <em>Text Content</em>}' attribute. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     * 
     * @see #getTextContent()
     * @generated
     * @ordered
     */
    protected static final String TEXT_CONTENT_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getTextContent() <em>Text Content</em>}' attribute. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     * 
     * @see #getTextContent()
     * @generated
     * @ordered
     */
    protected String textContent = TEXT_CONTENT_EDEFAULT;

    /**
     * The cached value of the '{@link #getContents() <em>Contents</em>}' containment reference list. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     * 
     * @see #getContents()
     * @generated
     * @ordered
     */
    protected EList contents = null;

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    protected DocumentationImpl() {
        super();
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    protected EClass eStaticClass() {
        return WsdlPackage.eINSTANCE.getDocumentation();
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    public EList getDeclaredNamespaces() {
        if (declaredNamespaces == null) {
            declaredNamespaces = new EObjectContainmentWithInverseEList(NamespaceDeclaration.class, this,
                                                                        WsdlPackage.DOCUMENTATION__DECLARED_NAMESPACES,
                                                                        WsdlPackage.NAMESPACE_DECLARATION__OWNER);
        }
        return declaredNamespaces;
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    public Documentation getDocumentation() {
        return documentation;
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    public NotificationChain basicSetDocumentation( Documentation newDocumentation,
                                                    NotificationChain msgs ) {
        Documentation oldDocumentation = documentation;
        documentation = newDocumentation;
        if (eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl(this, Notification.SET,
                                                                   WsdlPackage.DOCUMENTATION__DOCUMENTATION, oldDocumentation,
                                                                   newDocumentation);
            if (msgs == null) msgs = notification;
            else msgs.add(notification);
        }
        return msgs;
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    public void setDocumentation( Documentation newDocumentation ) {
        if (newDocumentation != documentation) {
            NotificationChain msgs = null;
            if (documentation != null) msgs = ((InternalEObject)documentation).eInverseRemove(this,
                                                                                              WsdlPackage.DOCUMENTATION__DOCUMENTED,
                                                                                              Documentation.class,
                                                                                              msgs);
            if (newDocumentation != null) msgs = ((InternalEObject)newDocumentation).eInverseAdd(this,
                                                                                                 WsdlPackage.DOCUMENTATION__DOCUMENTED,
                                                                                                 Documentation.class,
                                                                                                 msgs);
            msgs = basicSetDocumentation(newDocumentation, msgs);
            if (msgs != null) msgs.dispatch();
        } else if (eNotificationRequired()) eNotify(new ENotificationImpl(this, Notification.SET,
                                                                          WsdlPackage.DOCUMENTATION__DOCUMENTATION,
                                                                          newDocumentation, newDocumentation));
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    public EList getElements() {
        if (elements == null) {
            elements = new EObjectContainmentWithInverseEList(Element.class, this, WsdlPackage.DOCUMENTATION__ELEMENTS,
                                                              WsdlPackage.ELEMENT__ELEMENT_OWNER);
        }
        return elements;
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    public String getTextContent() {
        return textContent;
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    public void setTextContent( String newTextContent ) {
        String oldTextContent = textContent;
        textContent = newTextContent;
        if (eNotificationRequired()) eNotify(new ENotificationImpl(this, Notification.SET,
                                                                   WsdlPackage.DOCUMENTATION__TEXT_CONTENT, oldTextContent,
                                                                   textContent));
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    public EList getContents() {
        if (contents == null) {
            contents = new EObjectContainmentEList(EObject.class, this, WsdlPackage.DOCUMENTATION__CONTENTS);
        }
        return contents;
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    public Documented getDocumented() {
        if (eContainerFeatureID != WsdlPackage.DOCUMENTATION__DOCUMENTED) return null;
        return (Documented)eContainer;
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    public void setDocumented( Documented newDocumented ) {
        if (newDocumented != eContainer
            || (eContainerFeatureID != WsdlPackage.DOCUMENTATION__DOCUMENTED && newDocumented != null)) {
            if (EcoreUtil.isAncestor(this, newDocumented)) throw new IllegalArgumentException(
                                                                                              "Recursive containment not allowed for " + toString()); //$NON-NLS-1$
            NotificationChain msgs = null;
            if (eContainer != null) msgs = eBasicRemoveFromContainer(msgs);
            if (newDocumented != null) msgs = ((InternalEObject)newDocumented).eInverseAdd(this,
                                                                                           WsdlPackage.DOCUMENTED__DOCUMENTATION,
                                                                                           Documented.class,
                                                                                           msgs);
            msgs = eBasicSetContainer((InternalEObject)newDocumented, WsdlPackage.DOCUMENTATION__DOCUMENTED, msgs);
            if (msgs != null) msgs.dispatch();
        } else if (eNotificationRequired()) eNotify(new ENotificationImpl(this, Notification.SET,
                                                                          WsdlPackage.DOCUMENTATION__DOCUMENTED, newDocumented,
                                                                          newDocumented));
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public NotificationChain eInverseAdd( InternalEObject otherEnd,
                                          int featureID,
                                          Class baseClass,
                                          NotificationChain msgs ) {
        if (featureID >= 0) {
            switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
                case WsdlPackage.DOCUMENTATION__DECLARED_NAMESPACES:
                    return ((InternalEList)getDeclaredNamespaces()).basicAdd(otherEnd, msgs);
                case WsdlPackage.DOCUMENTATION__DOCUMENTATION:
                    if (documentation != null) msgs = ((InternalEObject)documentation).eInverseRemove(this,
                                                                                                      EOPPOSITE_FEATURE_BASE
                                                                                                      - WsdlPackage.DOCUMENTATION__DOCUMENTATION,
                                                                                                      null,
                                                                                                      msgs);
                    return basicSetDocumentation((Documentation)otherEnd, msgs);
                case WsdlPackage.DOCUMENTATION__ELEMENTS:
                    return ((InternalEList)getElements()).basicAdd(otherEnd, msgs);
                case WsdlPackage.DOCUMENTATION__DOCUMENTED:
                    if (eContainer != null) msgs = eBasicRemoveFromContainer(msgs);
                    return eBasicSetContainer(otherEnd, WsdlPackage.DOCUMENTATION__DOCUMENTED, msgs);
                default:
                    return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
            }
        }
        if (eContainer != null) msgs = eBasicRemoveFromContainer(msgs);
        return eBasicSetContainer(otherEnd, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public NotificationChain eInverseRemove( InternalEObject otherEnd,
                                             int featureID,
                                             Class baseClass,
                                             NotificationChain msgs ) {
        if (featureID >= 0) {
            switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
                case WsdlPackage.DOCUMENTATION__DECLARED_NAMESPACES:
                    return ((InternalEList)getDeclaredNamespaces()).basicRemove(otherEnd, msgs);
                case WsdlPackage.DOCUMENTATION__DOCUMENTATION:
                    return basicSetDocumentation(null, msgs);
                case WsdlPackage.DOCUMENTATION__ELEMENTS:
                    return ((InternalEList)getElements()).basicRemove(otherEnd, msgs);
                case WsdlPackage.DOCUMENTATION__CONTENTS:
                    return ((InternalEList)getContents()).basicRemove(otherEnd, msgs);
                case WsdlPackage.DOCUMENTATION__DOCUMENTED:
                    return eBasicSetContainer(null, WsdlPackage.DOCUMENTATION__DOCUMENTED, msgs);
                default:
                    return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
            }
        }
        return eBasicSetContainer(null, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public NotificationChain eBasicRemoveFromContainer( NotificationChain msgs ) {
        if (eContainerFeatureID >= 0) {
            switch (eContainerFeatureID) {
                case WsdlPackage.DOCUMENTATION__DOCUMENTED:
                    return eContainer.eInverseRemove(this, WsdlPackage.DOCUMENTED__DOCUMENTATION, Documented.class, msgs);
                default:
                    return eDynamicBasicRemoveFromContainer(msgs);
            }
        }
        return eContainer.eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public Object eGet( EStructuralFeature eFeature,
                        boolean resolve ) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case WsdlPackage.DOCUMENTATION__DECLARED_NAMESPACES:
                return getDeclaredNamespaces();
            case WsdlPackage.DOCUMENTATION__DOCUMENTATION:
                return getDocumentation();
            case WsdlPackage.DOCUMENTATION__ELEMENTS:
                return getElements();
            case WsdlPackage.DOCUMENTATION__TEXT_CONTENT:
                return getTextContent();
            case WsdlPackage.DOCUMENTATION__CONTENTS:
                return getContents();
            case WsdlPackage.DOCUMENTATION__DOCUMENTED:
                return getDocumented();
        }
        return eDynamicGet(eFeature, resolve);
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public void eSet( EStructuralFeature eFeature,
                      Object newValue ) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case WsdlPackage.DOCUMENTATION__DECLARED_NAMESPACES:
                getDeclaredNamespaces().clear();
                getDeclaredNamespaces().addAll((Collection)newValue);
                return;
            case WsdlPackage.DOCUMENTATION__DOCUMENTATION:
                setDocumentation((Documentation)newValue);
                return;
            case WsdlPackage.DOCUMENTATION__ELEMENTS:
                getElements().clear();
                getElements().addAll((Collection)newValue);
                return;
            case WsdlPackage.DOCUMENTATION__TEXT_CONTENT:
                setTextContent((String)newValue);
                return;
            case WsdlPackage.DOCUMENTATION__CONTENTS:
                getContents().clear();
                getContents().addAll((Collection)newValue);
                return;
            case WsdlPackage.DOCUMENTATION__DOCUMENTED:
                setDocumented((Documented)newValue);
                return;
        }
        eDynamicSet(eFeature, newValue);
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public void eUnset( EStructuralFeature eFeature ) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case WsdlPackage.DOCUMENTATION__DECLARED_NAMESPACES:
                getDeclaredNamespaces().clear();
                return;
            case WsdlPackage.DOCUMENTATION__DOCUMENTATION:
                setDocumentation((Documentation)null);
                return;
            case WsdlPackage.DOCUMENTATION__ELEMENTS:
                getElements().clear();
                return;
            case WsdlPackage.DOCUMENTATION__TEXT_CONTENT:
                setTextContent(TEXT_CONTENT_EDEFAULT);
                return;
            case WsdlPackage.DOCUMENTATION__CONTENTS:
                getContents().clear();
                return;
            case WsdlPackage.DOCUMENTATION__DOCUMENTED:
                setDocumented((Documented)null);
                return;
        }
        eDynamicUnset(eFeature);
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public boolean eIsSet( EStructuralFeature eFeature ) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case WsdlPackage.DOCUMENTATION__DECLARED_NAMESPACES:
                return declaredNamespaces != null && !declaredNamespaces.isEmpty();
            case WsdlPackage.DOCUMENTATION__DOCUMENTATION:
                return documentation != null;
            case WsdlPackage.DOCUMENTATION__ELEMENTS:
                return elements != null && !elements.isEmpty();
            case WsdlPackage.DOCUMENTATION__TEXT_CONTENT:
                return TEXT_CONTENT_EDEFAULT == null ? textContent != null : !TEXT_CONTENT_EDEFAULT.equals(textContent);
            case WsdlPackage.DOCUMENTATION__CONTENTS:
                return contents != null && !contents.isEmpty();
            case WsdlPackage.DOCUMENTATION__DOCUMENTED:
                return getDocumented() != null;
        }
        return eDynamicIsSet(eFeature);
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public int eBaseStructuralFeatureID( int derivedFeatureID,
                                         Class baseClass ) {
        if (baseClass == Documented.class) {
            switch (derivedFeatureID) {
                case WsdlPackage.DOCUMENTATION__DOCUMENTATION:
                    return WsdlPackage.DOCUMENTED__DOCUMENTATION;
                default:
                    return -1;
            }
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public int eDerivedStructuralFeatureID( int baseFeatureID,
                                            Class baseClass ) {
        if (baseClass == Documented.class) {
            switch (baseFeatureID) {
                case WsdlPackage.DOCUMENTED__DOCUMENTATION:
                    return WsdlPackage.DOCUMENTATION__DOCUMENTATION;
                default:
                    return -1;
            }
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public String toString() {
        if (eIsProxy()) return super.toString();

        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (textContent: "); //$NON-NLS-1$
        result.append(textContent);
        result.append(')');
        return result.toString();
    }

} // DocumentationImpl
