/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.gen.java;

import java.lang.reflect.Constructor;
import java.util.Set;
import java.util.TreeSet;
import org.jboss.tools.struts.gen.java.ParameterList;
import org.jboss.tools.struts.gen.java.TypeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstructorDesc {
    protected ParameterList params = new ParameterList();
    protected Set<String> exceptions = new TreeSet<String>();
    protected String body;
    protected int modifier;
    protected String comment;

    public ConstructorDesc() {
    }

    public ConstructorDesc(String[] names, String[] types) {
        if (names != null) {
            this.params.addAll(names, types);
        }
    }

    public ConstructorDesc(Constructor cons) {
        String type;
        Class<?>[] types = cons.getParameterTypes();
        int i = 0;
        while (i < types.length) {
            type = TypeUtil.getTypeName(types[i].getName());
            if (type.startsWith("java.lang.")) {
                type = type.substring(10);
            }
            int ind = type.lastIndexOf(46);
            String name = type.substring(ind + 1, ind + 2).toLowerCase();
            this.params.add(String.valueOf(name) + (i + 1), type);
            ++i;
        }
        types = cons.getExceptionTypes();
        i = 0;
        while (i < types.length) {
            type = TypeUtil.getTypeName(types[i].getName());
            if (type.startsWith("java.lang.")) {
                type = type.substring(10);
            }
            this.exceptions.add(type);
            ++i;
        }
        this.modifier = cons.getModifiers();
    }

    public ParameterList getParameterList() {
        return this.params;
    }

    public Set<String> getExceptions() {
        return this.exceptions;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public int getModifier() {
        return this.modifier;
    }

    public void setModifier(int modifier) {
        this.modifier = modifier;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ConstructorDesc)) {
            return false;
        }
        ConstructorDesc c = (ConstructorDesc)o;
        return this.params.equals(c.params);
    }
}

