/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.model.handlers;

import java.util.List;
import java.util.Properties;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.common.meta.action.XAction;
import org.jboss.tools.common.meta.action.impl.handlers.DefaultCreateHandler;
import org.jboss.tools.common.meta.action.impl.handlers.DefaultRemoveHandler;
import org.jboss.tools.common.model.ServiceDialog;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.undo.XTransactionUndo;
import org.jboss.tools.common.model.undo.XUndoManager;
import org.jboss.tools.common.model.undo.XUndoable;
import org.jboss.tools.struts.StrutsConstants;
import org.jboss.tools.struts.messages.StrutsUIMessages;
import org.jboss.tools.struts.model.ReferenceObjectImpl;
import org.jboss.tools.struts.model.StrutsProcessImpl;
import org.jboss.tools.struts.model.handlers.SelectOnDiagramHandler;
import org.jboss.tools.struts.model.handlers.StrutsRemoveUndo;
import org.jboss.tools.struts.model.handlers.page.DeletePageHandler;
import org.jboss.tools.struts.model.handlers.page.DeletePageLinkHandler;
import org.jboss.tools.struts.model.helpers.StrutsProcessHelper;
import org.jboss.tools.struts.model.helpers.StrutsProcessStructureHelper;

public class StrutsDeleteHandler
extends DefaultRemoveHandler
implements StrutsConstants {
    static String UNLINK_ACTION = "DeleteActions.Delete";
    String type = "";
    DeletePageLinkHandler deleteLink = new DeletePageLinkHandler();
    DeletePageHandler deletePage = new DeletePageHandler();

    public void executeHandler(XModelObject object, Properties prop) throws XModelException {
        XModelObject forward;
        if (object.getParent() == null) {
            return;
        }
        XModelObject process = StrutsProcessStructureHelper.instance.getProcess(object);
        this.type = object.getAttributeValue("type");
        String target = object.getAttributeValue("name");
        if ("link".equals(this.type) && "confirmed".equals(object.getAttributeValue("subtype"))) {
            if (prop == null) {
                prop = new Properties();
            }
            this.deleteLink.executeHandler(object, prop);
            if (prop.getProperty("consumed") != null) {
                return;
            }
        } else if ("page".equals(this.type)) {
            this.deletePage.executeHandler(object, prop);
            return;
        }
        List<XModelObject> referers = null;
        if (object instanceof ReferenceObjectImpl) {
            XModelObject ref = ((ReferenceObjectImpl)object).getReference();
            if ("StrutsProcessItem".equals(object.getModelEntity().getName())) {
                referers = StrutsProcessHelper.getReferers(object.getParent(), target);
            }
            if (ref != null) {
                object = ref;
            }
        } else if (object.getModelEntity().getName().startsWith("StrutsAction")) {
            String path = "action-mappings/" + object.getPathPart();
            XModelObject action = ((StrutsProcessImpl)process).getHelper().getObject(path);
            if (action != null) {
                referers = StrutsProcessHelper.getReferers(process, action.getPathPart());
            }
        } else if (object.getModelEntity().getName().startsWith("StrutsForward") && (forward = SelectOnDiagramHandler.getItemOnProcess(object)) != null) {
            referers = StrutsProcessHelper.getReferers(process, forward.getPathPart());
        }
        if (referers != null && referers.size() > 0) {
            ServiceDialog d = object.getModel().getService();
            String msg = NLS.bind((String)StrutsUIMessages.ACTION_IS_REFERENCED_REMOVE_REFERENCES, (Object)object.getPresentationString());
            d.showDialog(StrutsUIMessages.WARNING, msg, new String[]{StrutsUIMessages.OK}, null, 2);
            return;
        }
        XUndoManager undo = object.getModel().getUndoManager();
        XTransactionUndo u = new XTransactionUndo(NLS.bind((String)StrutsUIMessages.DELETE_NAME, (Object)DefaultCreateHandler.title((XModelObject)object, (boolean)false)), 2);
        undo.addUndoable((XUndoable)u);
        try {
            try {
                if (referers != null && referers.size() > 0) {
                    int i = 0;
                    while (i < referers.size()) {
                        XModelObject referer = referers.get(i);
                        XAction unlink = referer.getModelEntity().getActionList().getAction(UNLINK_ACTION);
                        if (unlink != null && unlink.isEnabled(referer)) {
                            unlink.executeHandler(referer, prop);
                        }
                        ++i;
                    }
                }
                XModelObject parent = object.getParent();
                if ("action".equals(this.type) && "unknown".equals(object.getAttributeValue("subtype"))) {
                    StrutsDeleteHandler.removeFromParent(object);
                    ((StrutsProcessImpl)parent).getHelper().removeAction(object);
                } else {
                    super.executeHandler(object, prop);
                }
            }
            catch (RuntimeException e) {
                undo.rollbackTransactionInProgress();
                throw e;
            }
        }
        finally {
            u.commit();
        }
    }

    public boolean isEnabled(XModelObject object) {
        this.type = "";
        if (object == null || !object.isActive()) {
            return false;
        }
        this.type = object.getAttributeValue("type");
        if (object instanceof ReferenceObjectImpl) {
            XModelObject ref = ((ReferenceObjectImpl)object).getReference();
            if ("StrutsProcessItemOutput".equals(object.getModelEntity().getName())) {
                String target = object.getAttributeValue("name");
                if (object.getParent().getAttributeValue("name").equals(target)) {
                    return false;
                }
            }
            if (ref != null) {
                object = ref;
            }
        }
        return super.isEnabled(object);
    }

    public static void removeFromParent(XModelObject object) {
        XModelObject parent = object.getParent();
        if (parent == null) {
            return;
        }
        object.removeFromParent();
        XUndoManager undo = object.getModel().getUndoManager();
        if (undo != null) {
            parent.getModel().getUndoManager().addUndoable((XUndoable)new StrutsRemoveUndo(parent, object));
        }
        parent.setModified(true);
    }

    public boolean getSignificantFlag(XModelObject object) {
        return !"page".equals(this.type) || this.deletePage.getFile(object) == null;
    }
}

