/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.model.helpers.path;

import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.jboss.tools.common.meta.action.XActionInvoker;
import org.jboss.tools.common.meta.action.impl.DefaultWizardDataValidator;
import org.jboss.tools.common.meta.action.impl.SpecialWizardSupport;
import org.jboss.tools.common.meta.action.impl.WizardDataValidator;
import org.jboss.tools.common.meta.action.impl.handlers.DefaultCreateHandler;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.undo.XTransactionUndo;
import org.jboss.tools.common.model.undo.XUndoManager;
import org.jboss.tools.common.model.undo.XUndoable;
import org.jboss.tools.struts.StrutsConstants;
import org.jboss.tools.struts.model.handlers.CreateConfigElementHandler;
import org.jboss.tools.struts.model.handlers.page.create.CreatePageContext;
import org.jboss.tools.struts.model.handlers.page.create.CreatePageSupport;
import org.jboss.tools.struts.model.helpers.StrutsProcessHelper;
import org.jboss.tools.struts.model.helpers.StrutsProcessStructureHelper;
import org.jboss.tools.struts.model.helpers.path.ActionsTree;
import org.jboss.tools.struts.webprj.model.helpers.WebModulesHelper;
import org.jboss.tools.struts.webprj.pattern.UrlPattern;

public class CreateActionForwardSupport
extends SpecialWizardSupport
implements StrutsConstants {
    Set<String> tiles = new TreeSet<String>();
    ActionsTree actions = null;
    int tools = 6;
    boolean isException = false;
    static int TILE = 0;
    static int PAGE = 1;
    static int ACTION = 2;
    int status = 0;
    private Validator validator = new Validator();

    public boolean isEnabled(XModelObject object) {
        if (!super.isEnabled(object)) {
            return false;
        }
        return !this.isImmutableAction(object);
    }

    private boolean isImmutableAction(XModelObject object) {
        String entity = object.getModelEntity().getName();
        if (!entity.startsWith("StrutsAction")) {
            return false;
        }
        if (object.getAttributeValue("forward").length() > 0) {
            return true;
        }
        String jtype = object.getAttributeValue("type");
        if ("org.apache.struts.actions.SwitchAction".equals(jtype)) {
            return true;
        }
        return "org.apache.struts.actions.ForwardAction".equals(jtype);
    }

    protected void reset() {
        this.tools = 6;
        this.isException = "yes".equals(this.action.getProperty("isException"));
        boolean isGlobalForward = "yes".equals(this.action.getProperty("isGlobalForward"));
        if (isGlobalForward) {
            this.tools = 7;
        } else if (this.isException) {
            this.tools = 3;
        }
        if (this.isException) {
            this.p.setProperty("isException", "yes");
        }
        if (isGlobalForward) {
            this.p.setProperty("isGlobalForward", "yes");
        }
        if ((this.tools & 1) != 0) {
            this.actions = new ActionsTree();
            this.actions.setModel(this.getTarget().getModel());
            this.actions.setConstraint(this.getTarget());
            this.p.put("actionsTree", this.actions);
        } else {
            this.actions = null;
            this.p.remove("actionsTree");
        }
        this.p.setProperty("tools", "" + this.tools);
        this.setAttributeContext(0, "path", this);
        this.resetTiles();
    }

    private void resetTiles() {
        this.tiles.clear();
        Set<String> tilePaths = StrutsProcessStructureHelper.instance.getTiles(this.getTarget());
        for (String s : tilePaths) {
            this.tiles.add(s.replace("#", "/"));
        }
        this.p.put("tiles", this.tiles);
    }

    public void action(String name) throws XModelException {
        if (OK.equals(name) || FINISH.equals(name)) {
            this.finish();
            this.setFinished(true);
        } else if (CANCEL.equals(name)) {
            this.setStepId(-1);
            this.getProperties().remove("selectedPath");
            this.setFinished(true);
        } else if (name.equals("...:path")) {
            this.status = this.validatePath();
            this.p.setProperty("selectedPath", this.getAttributeValue(0, "path"));
            XActionInvoker.invoke((String)"StrutsCreateActionForwardStep", (String)"EditPath", (XModelObject)this.getTarget(), (Properties)this.p);
            String path = this.p.getProperty("selectedPath");
            if (path != null) {
                this.setAttributeValue(0, "path", path);
                String tab = this.p.getProperty("selectedTab");
                if ("Pages".equals(tab)) {
                    this.status = PAGE;
                }
                if ("Tiles".equals(tab)) {
                    this.status = TILE;
                }
                if ("Actions".equals(tab)) {
                    this.status = ACTION;
                }
                if (!this.isException) {
                    this.validateContextRelative();
                }
            }
        }
    }

    private void validateContextRelative() {
        if (this.getTarget().getModelEntity().getName().endsWith("10")) {
            return;
        }
        if (this.status == PAGE) {
            this.setAttributeValue(0, "contextRelative", "");
        } else {
            String module = this.getSelectedModule();
            String thismodule = WebModulesHelper.getInstance(this.getTarget().getModel()).getModuleForConfig(StrutsProcessStructureHelper.instance.getParentFile(this.getTarget()));
            String cR = this.getAttributeValue(0, "contextRelative");
            if (thismodule != null && thismodule.equals(module)) {
                if ("true".equals(cR) || "yes".equals(cR)) {
                    this.setAttributeValue(0, "contextRelative", "");
                }
            } else if (!"true".equals(cR) && !"yes".equals(cR)) {
                this.setAttributeValue(0, "contextRelative", "true");
            }
        }
    }

    private String getSelectedModule() {
        if (this.status == TILE) {
            return null;
        }
        if (this.status == PAGE) {
            XModelObject fs = (XModelObject)this.getProperties().get("selectedFileSystem");
            return fs == null ? "" : WebModulesHelper.getInstance(fs.getModel()).getModuleForFileSystem(fs);
        }
        XModelObject a = (XModelObject)this.getProperties().get("selectedAction");
        return a == null || this.actions == null ? "" : this.actions.getModule(a);
    }

    protected void finish() throws XModelException {
        XUndoManager undo = this.getTarget().getModel().getUndoManager();
        XTransactionUndo u = new XTransactionUndo("create forward in " + DefaultCreateHandler.title((XModelObject)this.getTarget(), (boolean)false), 1);
        undo.addUndoable((XUndoable)u);
        try {
            try {
                this.transaction();
            }
            catch (Exception e) {
                undo.rollbackTransactionInProgress();
                throw new XModelException((Throwable)e);
            }
        }
        finally {
            u.commit();
        }
    }

    protected int validatePath() {
        String path = this.getAttributeValue(0, "path");
        if (path.equals(this.p.getProperty("selectedPath"))) {
            return this.status;
        }
        if (this.tiles.contains(path)) {
            return TILE;
        }
        int res = -1;
        CreatePageContext context = new CreatePageContext();
        context.setProcess(this.getTarget());
        context.resetRoots();
        UrlPattern up = StrutsProcessStructureHelper.instance.getUrlPattern(this.getTarget());
        if (path.indexOf(".") >= 0 && context.isPage(path)) {
            res = PAGE;
        } else if (up.isActionUrl(path)) {
            res = ACTION;
        } else {
            this.p.setProperty("selectedTab", "Tiles");
            this.p.setProperty("selectedPath", path);
            return TILE;
        }
        if (!path.startsWith("/") && path.length() > 0 && !StrutsProcessHelper.isHttp(path)) {
            path = "/" + path;
        }
        if (res == ACTION) {
            path = up.getActionPath(path);
            String root = context.getRoot();
            if (root != null) {
                path = up.getModuleRelativePath(path, root);
            }
        } else if (res == PAGE) {
            String oldRoot = context.getRoot();
            String jsppath = context.setRootByPath(path);
            String newRoot = context.getRoot();
            path = !this.isEqualRoots(oldRoot, newRoot) && newRoot != null ? String.valueOf(newRoot) + jsppath : jsppath;
        }
        this.setAttributeValue(0, "path", path);
        return res;
    }

    protected void transaction() throws Exception {
        this.status = this.validatePath();
        XModelObject object = this.getTarget();
        Properties p0 = this.extractStepData(0);
        String path = p0.getProperty("path");
        CreatePageContext context = new CreatePageContext();
        context.setProcess(object);
        context.resetRoots();
        if (this.status == PAGE && !StrutsProcessHelper.isHttp(path)) {
            String oldRoot = context.getRoot();
            String jsppath = context.setRootByPath(path);
            String newRoot = context.getRoot();
            XModelObject fs = context.getSelectedFileSystem();
            if (fs != null && this.isEqualRoots(oldRoot, newRoot)) {
                CreatePageSupport.createFile(fs, jsppath, null);
            }
        }
        XModelObject o = object.getModel().createModelObject(this.getChildEntity(), p0);
        if (!this.getTarget().getModelEntity().getName().startsWith("StrutsAction")) {
            CreateConfigElementHandler.setItemShape(o, this.p);
        }
        DefaultCreateHandler.addCreatedObject((XModelObject)object, (XModelObject)o, (Properties)this.getProperties());
        XModelObject process = StrutsProcessStructureHelper.instance.getProcess(object);
        StrutsProcessHelper.getHelper(process).updatePages();
        StrutsProcessHelper.getHelper(process).autolayout();
    }

    private String getChildEntity() {
        String base;
        String parentEntity = this.getTarget().getModelEntity().getName();
        String string = base = this.isException ? "StrutsException" : "StrutsForward";
        String suffix = parentEntity.endsWith("11") ? "11" : (parentEntity.endsWith("12") ? (this.isException ? "11" : "12") : String.valueOf(base) + "10");
        return String.valueOf(base) + suffix;
    }

    private boolean isEqualRoots(String r1, String r2) {
        return r1 == null ? r2 == null : r1.equals(r2);
    }

    public WizardDataValidator getValidator(int step) {
        this.validator.setSupport(this, step);
        return this.validator;
    }

    class Validator
    extends DefaultWizardDataValidator {
        Validator() {
        }

        public void validate(Properties data) {
            String entity = CreateActionForwardSupport.this.getChildEntity();
            if (!this.checkChild(this.support.getTarget(), entity, data)) {
                return;
            }
            super.validate(data);
        }
    }
}

