/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.webprj.model.helpers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jboss.tools.common.meta.action.impl.handlers.DefaultCreateHandler;
import org.jboss.tools.common.meta.constraint.XProperty;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.FileSystemsHelper;
import org.jboss.tools.common.model.filesystems.impl.FileAnyImpl;
import org.jboss.tools.common.model.filesystems.impl.FileSystemImpl;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.jboss.tools.jst.web.project.WebModuleConstants;
import org.jboss.tools.jst.web.project.WebModuleImpl;
import org.jboss.tools.jst.web.project.WebProject;
import org.jboss.tools.struts.webprj.pattern.PatternLoader;
import org.jboss.tools.struts.webprj.pattern.UrlPattern;
import org.jboss.tools.struts.webprj.resource.ResourceMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebModulesHelper
implements WebModuleConstants {
    public static String ENT_STRUTS_WEB_MODULE = "JstWebModule";
    private WebProject webProject;
    protected long timestamp = -700L;
    private Set<String> modules = new HashSet<String>();
    private Map<String, String> configs = new HashMap<String, String>();
    private PatternLoader patterns = new PatternLoader();
    private ResourceMapping resources = new ResourceMapping(this);
    static XModelObject[] EMPTY = new XModelObject[0];

    public static WebModulesHelper getInstance(XModel model) {
        WebModulesHelper instance = (WebModulesHelper)model.getManager("WebModulesHelper");
        if (instance == null) {
            instance = new WebModulesHelper();
            instance.setModel(model);
            model.addManager("WebModulesHelper", (Object)instance);
        }
        instance.update();
        return instance;
    }

    private void setModel(XModel model) {
        this.webProject = WebProject.getInstance((XModel)model);
    }

    public XModel getModel() {
        return this.webProject.getModel();
    }

    public WebProject getWebProject() {
        return this.webProject;
    }

    public Set<String> getModules() {
        return this.modules;
    }

    public String getModuleForConfig(XModelObject cfg) {
        return this.configs.get(XModelObjectLoaderUtil.getResourcePath((XModelObject)cfg));
    }

    public String getModuleForPath(String path, String current) {
        return path == null || !path.startsWith("/") ? null : (path.startsWith("//") ? "" : this.patterns.getUrlPatternForModule(current).getModule(path, this.modules, current));
    }

    public XModelObject getConfigForModule(XModel model, String module) {
        XModelObject m = model.getByPath("Web/" + WebModuleImpl.toWebModulePathPart((String)module));
        return m == null ? null : model.getByPath(m.getAttributeValue("model path"));
    }

    public XModelObject[] getConfigsForModule(XModel model, String module) {
        XModelObject c;
        XModelObject m = model.getByPath("Web/" + WebModuleImpl.toWebModulePathPart((String)module));
        if (m == null) {
            return EMPTY;
        }
        XModelObject[] cs = m.getChildren();
        String p = m.getAttributeValue("model path");
        XModelObject xModelObject = c = p.length() == 0 ? null : model.getByPath(p);
        if (cs.length == 0) {
            XModelObject[] xModelObjectArray;
            if (c == null) {
                xModelObjectArray = EMPTY;
            } else {
                XModelObject[] xModelObjectArray2 = new XModelObject[1];
                xModelObjectArray = xModelObjectArray2;
                xModelObjectArray2[0] = c;
            }
            return xModelObjectArray;
        }
        ArrayList<XModelObject> list = new ArrayList<XModelObject>();
        if (c != null) {
            list.add(c);
        }
        int i = 0;
        while (i < cs.length) {
            p = cs[i].getAttributeValue("model path");
            XModelObject xModelObject2 = c = p.length() == 0 ? null : model.getByPath(p);
            if (c != null) {
                list.add(c);
            }
            ++i;
        }
        return list.toArray(new XModelObject[0]);
    }

    public XModelObject getRootFileSystemForModule(XModel model, String module) {
        XModelObject m = model.getByPath("Web/" + WebModuleImpl.toWebModulePathPart((String)module));
        return m == null ? null : model.getByPath("FileSystems/" + m.getAttributeValue("root file system"));
    }

    public String getWebRootLocation() {
        XModelObject fs = FileSystemsHelper.getWebRoot((XModel)this.getModel());
        if (fs == null) {
            fs = this.getRootFileSystemForModule(this.getModel(), "");
        }
        if (!(fs instanceof FileSystemImpl)) {
            return null;
        }
        return ((FileSystemImpl)fs).getAbsoluteLocation();
    }

    public PatternLoader getPatternLoader() {
        return this.patterns;
    }

    public UrlPattern getUrlPattern(String module) {
        return this.patterns.getUrlPatternForModule(module);
    }

    public ResourceMapping getResourceMapping() {
        return this.resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        long ts;
        XModelObject root = this.getModel().getByPath("Web");
        long l = ts = root == null ? -111L : root.getTimeStamp();
        if (this.timestamp != ts) {
            this.timestamp = ts;
            WebModulesHelper webModulesHelper = this;
            synchronized (webModulesHelper) {
                this.reload(root);
            }
        }
    }

    private void reload(XModelObject root) {
        this.modules.clear();
        this.configs.clear();
        long l = this.timestamp = root == null ? -111L : root.getTimeStamp();
        if (root == null) {
            return;
        }
        XModelObject[] ms = root.getChildren(ENT_STRUTS_WEB_MODULE);
        int i = 0;
        while (i < ms.length) {
            String n = ms[i].getAttributeValue("name");
            String c = ms[i].getAttributeValue("model path");
            this.modules.add(n);
            this.configs.put(c, n);
            XModelObject[] cs = ms[i].getChildren();
            int k = 0;
            while (k < cs.length) {
                c = cs[k].getAttributeValue("model path");
                this.configs.put(c, n);
                ++k;
            }
            ++i;
        }
    }

    public XModelObject setModule(XModel model, String oldname, String name, String modelpath, String rootfilesystem) throws XModelException {
        XModelObject module;
        XModelObject web = model.getByPath("Web");
        XModelObject xModelObject = module = oldname == null || oldname.length() == 0 ? null : web.getChildByPath(oldname);
        if (module == null) {
            module = web.getChildByPath(name);
        }
        XModelObject src = FileSystemsHelper.getFileSystem((XModel)model, (String)"src");
        if (module == null) {
            Properties p = new Properties();
            p.setProperty("name", name);
            p.setProperty("model path", modelpath);
            p.setProperty("root file system", rootfilesystem);
            if (src != null) {
                p.setProperty("src file system", "src");
            }
            module = model.createModelObject(ENT_STRUTS_WEB_MODULE, p);
            DefaultCreateHandler.addCreatedObject((XModelObject)web, (XModelObject)module, (int)-1);
        } else {
            model.changeObjectAttribute(module, "name", name);
            model.changeObjectAttribute(module, "model path", modelpath);
            model.changeObjectAttribute(module, "root file system", rootfilesystem);
            if (src != null) {
                model.changeObjectAttribute(module, "src file system", "src");
            }
        }
        this.reload(web);
        return module;
    }

    public XModelObject[] getAllConfigs() {
        this.update();
        XModelObject web = this.getModel().getByPath("Web");
        if (web == null) {
            return new XModelObject[0];
        }
        ArrayList<XModelObject> list = new ArrayList<XModelObject>();
        XModelObject[] ms = web.getChildren(ENT_STRUTS_WEB_MODULE);
        int i = 0;
        while (i < ms.length) {
            String c = ms[i].getAttributeValue("model path");
            if (c.length() != 0) {
                XModelObject o = this.getModel().getByPath(c);
                if (o != null) {
                    list.add(o);
                }
                XModelObject[] cs = ms[i].getChildren();
                int k = 0;
                while (k < cs.length) {
                    c = cs[k].getAttributeValue("model path");
                    o = this.getModel().getByPath(c);
                    if (o != null) {
                        list.add(o);
                    }
                    ++k;
                }
            }
            ++i;
        }
        return list.toArray(new XModelObject[0]);
    }

    public XModelObject getFileSystem(String module) {
        XModelObject m = this.getModel().getByPath("Web/" + module.replace('/', '#'));
        return m == null ? null : this.getModel().getByPath("FileSystems/" + m.getAttributeValue("root file system"));
    }

    public XModelObject getWebRoot() {
        XModelObject fs = this.getFileSystem("");
        return fs != null ? fs : FileSystemsHelper.getWebRoot((XModel)this.getModel());
    }

    public String getModuleForFileSystem(XModelObject fs) {
        XModelObject web = this.getModel().getByPath("Web");
        if (web == null) {
            return "";
        }
        XModelObject[] ms = web.getChildren(ENT_STRUTS_WEB_MODULE);
        String n = fs.getAttributeValue("name");
        int i = 0;
        while (i < ms.length) {
            if (n.equals(ms[i].getAttributeValue("root file system"))) {
                return ms[i].getAttributeValue("name");
            }
            ++i;
        }
        return "";
    }

    public Map<String, XModelObject> getWebFileSystems() {
        HashMap<String, XModelObject> map = new HashMap<String, XModelObject>();
        XModelObject web = this.getModel().getByPath("Web");
        if (web == null) {
            return map;
        }
        XModelObject[] ms = web.getChildren(ENT_STRUTS_WEB_MODULE);
        int i = 0;
        while (i < ms.length) {
            String module = ms[i].getAttributeValue("name");
            String fsn = ms[i].getAttributeValue("root file system");
            XModelObject fs = FileSystemsHelper.getFileSystem((XModel)this.getModel(), (String)fsn);
            if (fs != null) {
                map.put(module, fs);
            }
            ++i;
        }
        return map;
    }

    public String getQualifiedPagePath(XModelObject page) {
        if (!page.isActive()) {
            return null;
        }
        XModelObject fs = page.getParent();
        String relative = "/" + FileAnyImpl.toFileName((XProperty)page);
        while (fs != null && fs.getFileType() != 3) {
            relative = "/" + fs.getAttributeValue("name") + relative;
            fs = fs.getParent();
        }
        return fs == null ? null : String.valueOf(this.getModuleForFileSystem(fs)) + relative;
    }
}

