/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.hibernate.eclipse.logging.LoggingHelper;
import org.hibernate.eclipse.logging.PluginLogManager;
import org.osgi.framework.BundleContext;

public class HibernatePlugin
extends Plugin {
    private static HibernatePlugin plugin;

    public HibernatePlugin() {
        HibernatePlugin.setPlugin(this);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.configureLog4jHooks();
        Log log = LogFactory.getLog(HibernatePlugin.class);
        log.info((Object)"HibernatePlugin Started");
    }

    private void configureLog4jHooks() {
        URL entry = this.getBundle().getEntry("hibernate-log4j.xml");
        if (entry == null) {
            entry = this.getBundle().getEntry("hibernate-log4j.properties");
        }
        if (entry != null) {
            LoggingHelper helper = LoggingHelper.getDefault();
            new PluginLogManager(this, helper, entry);
        }
    }

    public void stop(BundleContext context) throws Exception {
        LoggingHelper.getDefault().stop(context);
        super.stop(context);
        HibernatePlugin.setPlugin(null);
    }

    public static HibernatePlugin getDefault() {
        return plugin;
    }

    private static void setPlugin(HibernatePlugin plugin) {
        HibernatePlugin.plugin = plugin;
    }

    public static File getResourceItem(String strResPath) throws IOException {
        Path resourcePath = new Path(strResPath);
        File resourceFolder = resourcePath.toFile();
        URL entry = HibernatePlugin.getDefault().getBundle().getEntry(strResPath);
        URL resProject = FileLocator.resolve((URL)entry);
        String tplPrjLcStr = FileLocator.resolve((URL)resProject).getFile();
        resourceFolder = new File(tplPrjLcStr);
        return resourceFolder;
    }
}

