/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.meta.action.impl;

import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.jboss.tools.common.meta.XAdoptManager;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.plugin.ModelPlugin;

public abstract class CompoundAdoptManager
implements XAdoptManager {
    protected final synchronized XAdoptManager[] loadManagers(String extensionPoint) {
        IExtensionPoint p = Platform.getExtensionRegistry().getExtensionPoint(extensionPoint);
        if (p == null) {
            ModelPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.jboss.tools.common.model", 0, "Model warning: Cannot load extension point " + extensionPoint + ".", null));
            return new XAdoptManager[0];
        }
        IConfigurationElement[] es = p.getConfigurationElements();
        XAdoptManager[] array = new XAdoptManager[es.length];
        int length = 0;
        int i = 0;
        while (i < es.length) {
            String cls = es[i].getAttribute("class");
            if (cls != null && cls.length() != 0) {
                try {
                    XAdoptManager m = (XAdoptManager)es[i].createExecutableExtension("class");
                    if (m != null) {
                        array[length] = m;
                        ++length;
                    }
                }
                catch (CoreException e) {
                    ModelPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.jboss.tools.common.model", 0, "Model warning: Cannot load class " + cls + ".", (Throwable)e));
                }
                catch (ClassCastException e2) {
                    ModelPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.jboss.tools.common.model", 0, "Model warning: Cannot load class " + cls + ".", (Throwable)e2));
                }
            }
            ++i;
        }
        if (length < array.length) {
            XAdoptManager[] array2 = new XAdoptManager[length];
            System.arraycopy(array, 0, array2, 0, length);
            return array2;
        }
        return array;
    }

    public abstract XAdoptManager[] getManagers();

    public boolean isAdoptable(XModelObject target, XModelObject object) {
        XAdoptManager[] ms = this.getManagers();
        int i = 0;
        while (i < ms.length) {
            if (ms[i].isAdoptable(target, object)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void adopt(XModelObject target, XModelObject object, Properties p) throws XModelException {
        XAdoptManager[] ms = this.getManagers();
        int i = 0;
        while (i < ms.length) {
            if (ms[i].isAdoptable(target, object)) {
                ms[i].adopt(target, object, p);
                return;
            }
            ++i;
        }
    }
}

