/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.markers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.jboss.tools.common.model.XJob;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.impl.XModelObjectImpl;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.util.EclipseResourceUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMarkerManager
implements IResourceChangeListener {
    private static XMarkerManager instance;
    private Map<IProject, Set<XModelObject>> errorObjects = new HashMap<IProject, Set<XModelObject>>();
    private Map<IProject, Set<XModelObject>> warningObjects = new HashMap<IProject, Set<XModelObject>>();

    public static XMarkerManager getInstance() {
        if (instance == null) {
            instance = new XMarkerManager();
        }
        return instance;
    }

    private XMarkerManager() {
        this.reload(null);
        ModelPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta d;
        IProject project = null;
        Object o = event.getSource();
        if (event.getType() == 4 && event.getResource() instanceof IProject) {
            this.errorObjects.remove((IProject)event.getResource());
            this.warningObjects.remove((IProject)event.getResource());
            return;
        }
        if (o instanceof IWorkspace && (d = event.getDelta()) != null) {
            IResourceDelta[] cs = d.getAffectedChildren();
            int i = 0;
            while (i < cs.length && project == null) {
                project = cs[i].getResource().getProject();
                ++i;
            }
        }
        final IProject p = project;
        if (ResourcesPlugin.getWorkspace().isTreeLocked()) {
            XJob.addRunnable(new XJob.XRunnable(){

                public String getId() {
                    return "XMarkerManager";
                }

                public void run() {
                    XMarkerManager.this.reload(p);
                }
            });
        } else {
            this.reload(p);
        }
    }

    public void reload(IProject project) {
        IMarker[] ms = new IMarker[]{};
        try {
            ms = project == null || !project.isAccessible() ? ModelPlugin.getWorkspace().getRoot().findMarkers("org.eclipse.core.resources.problemmarker", true, 2) : project.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
        }
        catch (CoreException e) {
            ModelPlugin.getPluginLog().logError((Throwable)e);
        }
        Set<XModelObject> os = this.errorObjects.get(project);
        if (os == null) {
            os = new HashSet<XModelObject>();
            this.errorObjects.put(project, os);
        }
        this.reload(ms, os, 2);
        os = this.warningObjects.get(project);
        if (os == null) {
            os = new HashSet<XModelObject>();
            this.warningObjects.put(project, os);
        }
        this.reload(ms, os, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reload(IMarker[] ms, Set<XModelObject> objects, int severity) {
        XModelObject o2;
        HashSet<XModelObject> es = new HashSet<XModelObject>();
        int i = 0;
        while (i < ms.length) {
            if (severity == ms[i].getAttribute("severity", 0)) {
                IResource r = ms[i].getResource();
                o2 = EclipseResourceUtil.getObjectByResource(r);
                if (o2 == null) {
                    o2 = EclipseResourceUtil.createObjectForResource(r);
                }
                if (o2 != null) {
                    String path = ms[i].getAttribute("path", null);
                    XModelObject xModelObject = o2 = path == null ? o2 : o2.getModel().getByPath(path);
                    if (o2 != null) {
                        es.add(o2);
                        String attr = ms[i].getAttribute("attribute", null);
                        if (attr != null && attr.length() > 0) {
                            ((XModelObjectImpl)o2).addErrorAttributeDirty(attr);
                        }
                    }
                }
            }
            ++i;
        }
        Set<XModelObject> set = objects;
        synchronized (set) {
            Iterator<XModelObject> it = objects.iterator();
            while (it.hasNext()) {
                o2 = it.next();
                if (!es.contains(o2)) {
                    if (o2.getErrorState() == severity) {
                        o2.setErrorState(0);
                    }
                    it.remove();
                    continue;
                }
                if (!es.contains(o2)) continue;
                if (severity > o2.getErrorState()) {
                    o2.setErrorState(severity);
                } else {
                    ((XModelObjectImpl)o2).commitErrorAttributes();
                }
                es.remove(o2);
            }
            for (XModelObject o2 : es) {
                if (severity > o2.getErrorState()) {
                    o2.setErrorState(severity);
                } else {
                    ((XModelObjectImpl)o2).commitErrorAttributes();
                }
                if (objects.contains(o2)) continue;
                objects.add(o2);
            }
        }
    }

    public int getErrorState(XModelObject object) {
        if (object == null) {
            return 0;
        }
        if (object.getErrorState() == 2 || object.getErrorChildCount() > 0) {
            return 2;
        }
        if (object.getErrorState() == 1 || object.getWarningChildCount() > 0) {
            return 1;
        }
        return 0;
    }

    public boolean hasErrors(XModelObject object) {
        return object != null && (object.getErrorState() == 2 || object.getErrorChildCount() > 0);
    }

    public boolean hasWarnings(XModelObject object) {
        return object != null && (object.getErrorState() == 1 || object.getWarningChildCount() > 0);
    }

    public boolean hasErrors(XModelObject object, String attribute) {
        if (attribute == null) {
            return this.hasErrors(object);
        }
        if (object.getErrorState() == 0) {
            return false;
        }
        return object.getAttributeErrorState(attribute);
    }

    public String getError(XModelObject object, String attribute) {
        IFile file;
        XModelObject f = ((XModelObjectImpl)object).getResourceAncestor();
        IFile iFile = file = f == null ? null : (IFile)f.getAdapter(IFile.class);
        if (file == null) {
            return null;
        }
        IMarker[] ms = null;
        try {
            ms = file.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
        }
        catch (CoreException coreException) {
            return null;
        }
        if (ms == null) {
            return null;
        }
        int i = 0;
        while (i < ms.length) {
            String attr;
            XModelObject o = object;
            String path = ms[i].getAttribute("path", null);
            XModelObject xModelObject = o = path == null ? o : o.getModel().getByPath(path);
            if (o != null && (attr = ms[i].getAttribute("attribute", null)) != null && attr.equals(attribute)) {
                return ms[i].getAttribute("message", null);
            }
            ++i;
        }
        return null;
    }
}

