/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.options.impl;

import java.util.Properties;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.meta.XChild;
import org.jboss.tools.common.meta.XModelEntity;
import org.jboss.tools.common.model.XModelConstants;
import org.jboss.tools.common.model.options.SharableConstants;
import org.jboss.tools.common.model.options.SharableElement;
import org.jboss.tools.common.model.options.impl.SharableContainerImpl;
import org.jboss.tools.common.model.options.impl.SharableContainerLoader;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SharableLoaderImpl
implements SharableConstants {
    XModelObjectLoaderUtil loader = new XModelObjectLoaderUtil();

    public void loadSharable(Element element, SharableElement sharable, String scopename) {
        sharable.setScope(scopename);
        this.loadAttributes(element, sharable, scopename);
        this.loadChildren(element, sharable, scopename);
        String precisescope = element.getAttribute("SCOPE");
        sharable.setScope(this.reduceScopeName(scopename, precisescope));
    }

    public void loadAttributes(Element element, SharableElement sharable, String scopename) {
        XAttribute[] an = sharable.getModelEntity().getAttributes();
        int i = 0;
        while (i < an.length) {
            String xml = an[i].getXMLName();
            if (xml != null && xml.trim().length() != 0) {
                String v = this.loader.getAttribute(element, xml);
                if (v != null && "Note2".equals(an[i].getEditor().getName())) {
                    v = XModelObjectLoaderUtil.loadFromXMLAttribute(v);
                }
                if (v != null) {
                    sharable.setAttributeValue(an[i].getName(), v);
                }
            }
            ++i;
        }
    }

    public void loadChildren(Element element, SharableElement sharable, String scopename) {
        NodeList nl = element.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node c = nl.item(i);
            if (c.getNodeType() == 1) {
                this.loadChild((Element)c, sharable, scopename);
            }
            ++i;
        }
    }

    public void loadChild(Element element, SharableElement sharable, String scopename) {
        String en = XModelObjectLoaderUtil.getModelEntityAttribute(element);
        if (en == null) {
            return;
        }
        XModelEntity ent = sharable.getModel().getMetaData().getEntity(en);
        if (ent == null) {
            return;
        }
        boolean hasName = ent.getAttribute("name") != null;
        String name = !hasName ? element.getNodeName() : element.getAttribute("NAME");
        SharableElement sc = sharable.findSharableChild(name);
        if (sc == null) {
            Properties p = new Properties();
            if (hasName) {
                p.setProperty("name", name);
            }
            sc = (SharableElement)sharable.getModel().createModelObject(en, p);
            sc.setScopeExists("project", false);
            sharable.addChild(sc);
            if (!hasName) {
                sharable.setName(name);
            }
        }
        if (sc instanceof SharableContainerImpl) {
            new SharableContainerLoader().loadSharable(element, sc, scopename);
        } else {
            this.loadSharable(element, sc, scopename);
        }
    }

    public void saveSharable(Element parent, SharableElement sharable, String scopename) {
        if (!sharable.scopeExists(scopename)) {
            return;
        }
        XModelEntity entity = sharable.getModelEntity();
        String en = entity.getName();
        if (en.startsWith("Sharable")) {
            en = en.substring(8);
        }
        Element element = parent.getOwnerDocument().createElement(en);
        parent.appendChild(element);
        this.saveAttributes(element, sharable, scopename);
        this.saveChildren(element, sharable, scopename);
    }

    public void saveAttributes(Element element, SharableElement sharable, String scopename) {
        XModelEntity entity = sharable.getModelEntity();
        element.setAttribute(XModelConstants.XMODEL_ENTITY_ATTR, entity.getName());
        XAttribute[] as = sharable.getModelEntity().getAttributes();
        element.setAttribute("SCOPE", this.reduceScopeName(scopename, sharable.getScope()));
        int i = 0;
        while (i < as.length) {
            String xml;
            if (!as[i].isFake() && (xml = as[i].getXMLName()) != null && xml.trim().length() != 0) {
                String v = sharable.getAttributeValue(as[i].getName(), scopename);
                if (v != null && "Note2".equals(as[i].getEditor().getName())) {
                    v = XModelObjectLoaderUtil.saveToXMLAttribute(v);
                }
                this.loader.saveAttribute(element, xml, v);
            }
            ++i;
        }
    }

    public void saveChildren(Element element, SharableElement sharable, String scopename) {
        SharableElement[] se = sharable.getSharableChildren();
        int i = 0;
        while (i < se.length) {
            if (se[i] != null) {
                if (se[i] instanceof SharableContainerImpl) {
                    new SharableContainerLoader().saveSharable(element, se[i], scopename);
                } else {
                    this.saveSharable(element, se[i], scopename);
                }
            }
            ++i;
        }
    }

    public String reduceScopeName(String currentscope, String precisescope) {
        return currentscope;
    }

    public void loadSystemSharable(SharableElement sharable) {
        XModelEntity entity = sharable.getModelEntity();
        XChild[] children = entity.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i].isRequired()) {
                SharableElement c = (SharableElement)sharable.getModel().createModelObject(children[i].getName(), new Properties());
                if (c == null) {
                    ModelPlugin.getPluginLog().logInfo("Could not create sharable folder " + children[i].getName());
                } else {
                    c.setScope("project");
                    this.loadSystemSharable(c);
                    sharable.addChild(c);
                }
            }
            ++i;
        }
    }
}

