/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.project;

import java.io.File;
import java.util.Properties;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.jboss.tools.common.model.XModelConstants;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.util.XMLUtil;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.w3c.dom.Element;

public class ProjectHome {
    public String getLocation(IProject project) {
        try {
            String location = project.getDescription().getLocation() == null ? project.getLocation().toString() : project.getDescription().getLocation().toString();
            return this.getLocation(location);
        }
        catch (CoreException e) {
            ModelPlugin.getPluginLog().logError((Throwable)e);
            return "";
        }
    }

    public String getLocation(String projectLocation) {
        String location = projectLocation;
        File f = new File(String.valueOf(location) + "/" + "org.jboss.tools.common.model.temp");
        File ep = new File(String.valueOf(location) + "/" + ".settings/org.jboss.tools.jst.web.xml");
        if (ep.isFile()) {
            if (f.isFile()) {
                f.delete();
            }
            return this.getLocationFrom_project_File(location, ep);
        }
        if (f.isFile()) {
            return this.getLocationFrom_temp_File(location, f);
        }
        return "";
    }

    private String getLocationFrom_project_File(String location, File ss) {
        Element element = XMLUtil.getElement(ss);
        String path = "";
        if (element.hasAttribute("workspace-home")) {
            path = element.getAttribute("workspace-home");
        } else if (element.hasAttribute("WORKSPACE_HOME")) {
            path = element.getAttribute("WORKSPACE_HOME");
        }
        String q = path.equals(".") ? location : (path.startsWith("./") ? String.valueOf(location) + path.substring(1) : path);
        return q;
    }

    private String getLocationFrom_temp_File(String location, File s) {
        String path = XModelObjectLoaderUtil.getCDATA(XMLUtil.getElement(s));
        String q = path.equals(".") ? location : (path.startsWith("./") ? String.valueOf(location) + path.substring(1) : path);
        s.delete();
        return q;
    }

    public static boolean getLocation(IProject project, Properties p) {
        IPath webInfPath = null;
        if (ComponentCore.createComponent((IProject)project) != null) {
            webInfPath = ProjectHome.getWebInfPath(project);
        }
        if (webInfPath == null) {
            return false;
        }
        IFolder webInfFolder = ResourcesPlugin.getWorkspace().getRoot().getFolder(webInfPath);
        p.setProperty(XModelConstants.WORKSPACE, webInfFolder.getLocation().toString());
        p.setProperty(XModelConstants.WORKSPACE_OLD, webInfFolder.getLocation().toString());
        return true;
    }

    public static IPath getWebInfPath(IProject project) {
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        if (component == null || component.getRootFolder() == null) {
            return null;
        }
        IVirtualFolder webInfDir = component.getRootFolder().getFolder((IPath)new Path("/WEB-INF"));
        IPath modulePath = webInfDir.getWorkspaceRelativePath();
        return !webInfDir.exists() ? null : modulePath;
    }

    public static IPath getFirstWebContentPath(IProject project) {
        IPath modulePath = null;
        IVirtualComponent vc = ComponentCore.createComponent((IProject)project);
        if (vc == null || vc.getRootFolder() == null) {
            return null;
        }
        if (ModuleCoreNature.isFlexibleProject((IProject)project)) {
            modulePath = vc.getRootFolder().getWorkspaceRelativePath();
        }
        return modulePath;
    }
}

