/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor;

import org.eclipse.swt.graphics.Point;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.jboss.tools.vpe.editor.menu.ITextNodeSplitter;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class TextNodeSplitterImpl
implements ITextNodeSplitter {
    private Text node;
    private Node parent;
    private IndexedRegion region;
    private int offset1 = 0;
    private int offset2 = 0;
    private boolean split1 = true;
    private boolean split2 = true;

    public TextNodeSplitterImpl(Point range, Text node) {
        String str;
        this.node = node;
        this.parent = node.getParentNode();
        this.region = (IndexedRegion)node;
        this.offset1 = range.x - this.region.getStartOffset();
        if (this.offset1 == 0) {
            this.split1 = false;
        } else if (this.offset1 > 0 && this.isSpacing(str = node.getNodeValue().substring(0, this.offset1))) {
            this.split1 = false;
        }
        this.offset2 = range.y;
        if (this.region.getEndOffset() - (range.x + range.y) == 0) {
            this.split2 = false;
        } else if (this.region.getEndOffset() - (range.x + range.y) > 0 && this.isSpacing(str = node.getNodeValue().substring(this.offset1 + range.y, node.getNodeValue().length()))) {
            this.split2 = false;
        }
    }

    @Override
    public int getSplitIndex(int index) {
        int nodeIndex = this.getIndex(this.parent, this.node);
        if (nodeIndex == index) {
            if (this.split1) {
                return index + 1;
            }
            return index;
        }
        if (nodeIndex == index + 1) {
            if (this.split1 && this.split2) {
                return index + 1;
            }
            return index;
        }
        return index + 1;
    }

    @Override
    public void nodeSplit(int type) {
        if (type == 1) {
            if (this.split1 && this.split2) {
                this.node.splitText(this.offset1);
            } else if (this.split1) {
                this.node.splitText(this.offset1);
            } else if (this.split2) {
                this.node.splitText(this.offset1 + this.offset2);
            }
        } else if (type == 2) {
            if (this.split1) {
                this.node.splitText(this.offset1);
            }
        } else if (type == 3 && this.split2) {
            this.node.splitText(this.offset1 + this.offset2);
        }
    }

    private boolean isSpacing(String str) {
        return "".endsWith(str.trim());
    }

    private int getIndex(Node parentNode, Node child) {
        NodeList nodeList = parentNode.getChildNodes();
        int index = -1;
        int size = nodeList.getLength();
        int i = 0;
        while (i < size) {
            if (nodeList.item(i) == child) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }
}

