/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.toolbar;

import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.jboss.tools.vpe.editor.toolbar.IVpeToolBar;

public abstract class SplitToolBar
implements IVpeToolBar {
    private int maxItemHeight = 0;
    protected CoolBar coolBar;

    protected abstract void createItems(ToolBar var1);

    @Override
    public void createToolBarControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayoutData((Object)new GridData(768));
        comp.setLayout((Layout)new GridLayout());
        this.coolBar = new CoolBar(comp, 0x800040);
        this.coolBar.setLayoutData((Object)new GridData(1808));
        final ToolBar toolBar = new ToolBar((Composite)this.coolBar, 0x800040);
        this.createItems(toolBar);
        CoolItem coolItem = new CoolItem(this.coolBar, 4);
        coolItem.setControl((Control)toolBar);
        Point size = toolBar.computeSize(-1, -1);
        Point coolSize = coolItem.computeSize(size.x, this.getMaxItemHeight());
        coolItem.setSize(coolSize);
        coolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (event.detail == 4) {
                    int shownItemsCount = SplitToolBar.this.getShownItemsCount(toolBar);
                    Shell floatingShell = SplitToolBar.this.createFloatingShell(toolBar, shownItemsCount);
                    Point pt = SplitToolBar.this.coolBar.toDisplay(new Point(event.x, event.y));
                    SplitToolBar.this.arrange((Control)floatingShell, pt);
                    floatingShell.setVisible(true);
                    floatingShell.setFocus();
                    floatingShell.addShellListener((ShellListener)new ShellAdapter(){

                        public void shellDeactivated(ShellEvent e) {
                            e.widget.dispose();
                        }
                    });
                }
            }
        });
        toolBar.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                int shownItemsCount = SplitToolBar.this.getShownItemsCount(toolBar);
                SplitToolBar.this.ensureVisibility(shownItemsCount, toolBar);
            }
        });
        this.coolBar.pack();
        toolBar.pack(true);
    }

    protected void cloneItem(ToolBar destBar, ToolItem item, SelectionListener selectionListener) {
        ToolItem copiedItem = this.createToolItem(destBar, item.getStyle(), item.getImage(), item.getToolTipText());
        copiedItem.setEnabled(item.getEnabled());
        copiedItem.setSelection(item.getSelection());
        this.copySelectionListeners((Widget)item, (Widget)copiedItem);
        copiedItem.addSelectionListener(selectionListener);
    }

    protected void cloneCombo(Composite parent, SelectionListener selectionListener, Combo combo) {
        Combo copiedCombo = this.createCombo(parent, combo.getStyle(), combo.getToolTipText(), Arrays.asList(combo.getItems()), combo.getSelectionIndex());
        copiedCombo.setEnabled(combo.getEnabled());
        this.copySelectionListeners((Widget)combo, (Widget)copiedCombo);
        copiedCombo.addSelectionListener(selectionListener);
    }

    protected void copySelectionListeners(Widget src, Widget dest) {
        Listener[] listeners;
        Listener[] listenerArray = listeners = src.getListeners(13);
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Listener listener = listenerArray[n2];
            dest.addListener(13, listener);
            ++n2;
        }
    }

    protected ToolItem createToolItem(ToolBar bar, int style, Image image, String toolTipText) {
        ToolItem item = null;
        item = new ToolItem(bar, style);
        item.setImage(image);
        item.setToolTipText(toolTipText);
        this.updateMaxItemHeight(item.getBounds().height);
        return item;
    }

    protected Combo createComboToolItem(ToolBar bar, int style, String toolTipText, List<String> comboItems, int selectionIndex) {
        Combo combo = this.createCombo((Composite)bar, style, toolTipText, comboItems, selectionIndex);
        ToolItem sep = new ToolItem(bar, 2);
        sep.setWidth(combo.getSize().x);
        this.updateMaxItemHeight(combo.getSize().y);
        sep.setControl((Control)combo);
        return combo;
    }

    protected Combo createCombo(Composite parent, int style, String toolTipText, List<String> comboItems, int selectionIndex) {
        Combo combo = new Combo(parent, style);
        combo.setItems(comboItems.toArray(new String[comboItems.size()]));
        combo.setToolTipText(toolTipText);
        combo.select(selectionIndex);
        combo.pack();
        return combo;
    }

    private void arrange(Control control, Point point) {
        Point size = control.getSize();
        Rectangle bounds = new Rectangle(point.x, point.y, size.x, size.y);
        control.setBounds(this.arrange(bounds, control.getDisplay().getBounds()));
    }

    private Rectangle arrange(Rectangle bounds, Rectangle clientArea) {
        Rectangle result = new Rectangle(bounds.x, bounds.y, bounds.width, bounds.height);
        if (result.x + result.width > clientArea.x + clientArea.width) {
            result.x = clientArea.x + clientArea.width - result.width;
        }
        if (result.x < clientArea.x) {
            result.x = clientArea.x;
        }
        if (result.y + result.height > clientArea.y + clientArea.height) {
            result.y = clientArea.y + clientArea.height - result.height;
        }
        if (result.y < clientArea.y) {
            result.y = clientArea.y;
        }
        return result;
    }

    private void ensureVisibility(int shownItemsCount, ToolBar toolBar) {
        int toolItemCount = toolBar.getItemCount();
        int i = 0;
        while (i < toolItemCount) {
            ToolItem toolItem = toolBar.getItem(i);
            Control control = toolItem.getControl();
            if (control != null) {
                control.setVisible(i < shownItemsCount);
            }
            ++i;
        }
    }

    private Shell createFloatingShell(ToolBar fixedToolBar, int firstItemIndex) {
        final Shell floatingShell = new Shell(this.coolBar.getShell(), 16384);
        FillLayout shellLayout = new FillLayout(512);
        shellLayout.marginHeight = 5;
        shellLayout.marginWidth = 5;
        shellLayout.spacing = 5;
        floatingShell.setLayout((Layout)shellLayout);
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                floatingShell.dispose();
            }
        };
        ToolBar buttonsBar = null;
        ToolItem[] tools = fixedToolBar.getItems();
        int j = firstItemIndex;
        while (j < tools.length) {
            ToolItem tool = tools[j];
            int style = tool.getStyle();
            if ((style & 2) != 0) {
                Control control = tool.getControl();
                if (control instanceof Combo) {
                    this.cloneCombo((Composite)floatingShell, (SelectionListener)selectionListener, (Combo)control);
                }
            } else {
                if (buttonsBar == null) {
                    buttonsBar = new ToolBar((Composite)floatingShell, 0x800040);
                }
                this.cloneItem(buttonsBar, tool, (SelectionListener)selectionListener);
            }
            ++j;
        }
        floatingShell.pack();
        return floatingShell;
    }

    private int getShownItemsCount(ToolBar bar) {
        Rectangle barBounds = bar.getBounds();
        Point pt = this.coolBar.toDisplay(new Point(barBounds.x, barBounds.y));
        barBounds.x = pt.x;
        barBounds.y = pt.y;
        ToolItem[] tools = bar.getItems();
        int i = 0;
        while (i < tools.length) {
            Rectangle toolBounds = tools[i].getBounds();
            pt = bar.toDisplay(new Point(toolBounds.x, toolBounds.y));
            toolBounds.x = pt.x;
            toolBounds.y = pt.y;
            Rectangle intersection = barBounds.intersection(toolBounds);
            if (!intersection.equals((Object)toolBounds)) break;
            ++i;
        }
        return i;
    }

    private void updateMaxItemHeight(int oneOfHeights) {
        this.maxItemHeight = Math.max(this.maxItemHeight, oneOfHeights);
    }

    private int getMaxItemHeight() {
        return this.maxItemHeight;
    }
}

