/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.dnd;

import java.util.Properties;
import java.util.Vector;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.jboss.tools.common.meta.XAdoptManager;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.XModelTransferBuffer;
import org.jboss.tools.common.model.event.ActionDeclinedException;
import org.jboss.tools.common.model.options.impl.PaletteAdopt;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.dnd.DnDUtil;
import org.jboss.tools.common.model.ui.dnd.IControlDragDropProvider;
import org.jboss.tools.common.model.ui.dnd.IControlDropListener;
import org.jboss.tools.common.model.ui.dnd.ModelTransfer;
import org.jboss.tools.common.model.ui.navigator.TreeViewerDragDropProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlDragDrop {
    static XAdoptManager paletteAdopt;
    protected IControlDragDropProvider provider;
    XModelObject draggedObject = null;

    static {
        XAdoptManager[] ms = new PaletteAdopt().getManagers();
        if (ms != null && ms.length > 0) {
            paletteAdopt = ms[0];
        }
    }

    public Control getControl() {
        return this.provider.getControl();
    }

    public void setProvider(IControlDragDropProvider provider) {
        this.provider = provider;
    }

    protected XModelObject getModelObjectForWidget(Widget widget) {
        return this.provider.getModelObjectForWidget(widget);
    }

    protected XModelObject getLeadSelection() {
        Widget[] w = this.provider.getSelection();
        return w == null || w.length == 0 ? null : this.getModelObjectForWidget(w[0]);
    }

    protected XModelObject[] getMultiSelection() {
        Widget[] w = this.provider.getSelection();
        if (w == null || w.length < 2) {
            return null;
        }
        XModelObject[] os = new XModelObject[w.length];
        int i = 0;
        while (i < os.length) {
            os[i] = this.getModelObjectForWidget(w[i]);
            ++i;
        }
        return os;
    }

    public void enable() {
        this.enableDrag();
        this.enableDrop();
    }

    public void enableDrag() {
        DragSource ds = new DragSource(this.getControl(), 3);
        Transfer[] ts = new Transfer[]{ModelTransfer.getInstance(), TextTransfer.getInstance()};
        ds.setTransfer(ts);
        ds.addDragListener((DragSourceListener)new DSL());
    }

    public void enableDrop() {
        DropTarget old = (DropTarget)this.getControl().getData("DropTarget");
        if (old != null) {
            old.setTransfer(new Transfer[]{ModelTransfer.getInstance(), TextTransfer.getInstance()});
            old.addDropListener((DropTargetListener)new DTL());
        } else {
            DropTarget target = new DropTarget(this.getControl(), 3);
            Transfer[] types = new Transfer[]{ModelTransfer.getInstance()};
            target.setTransfer(types);
            target.addDropListener((DropTargetListener)new DTL());
        }
    }

    void ignore() {
    }

    private static Vector<TreeItem> getTreeExpandedItems(Tree tree) {
        TreeItem[] items = tree.getItems();
        Vector<TreeItem> result = new Vector<TreeItem>();
        int i = 0;
        while (items != null && i < items.length) {
            result.add(result.size(), items[i]);
            if (items[i].getExpanded()) {
                ControlDragDrop.fillTreeItemRows(items[i].getItems(), result);
            }
            ++i;
        }
        return result;
    }

    private static Vector<TreeItem> fillTreeItemRows(TreeItem[] items, Vector<TreeItem> result) {
        if (result == null) {
            result = new Vector();
        }
        int i = 0;
        while (items != null && i < items.length) {
            result.add(result.size(), items[i]);
            if (items[i].getExpanded()) {
                ControlDragDrop.fillTreeItemRows(items[i].getItems(), result);
            }
            ++i;
        }
        return result;
    }

    public Widget findTreeItem(int x, int y) {
        Tree tree = this.provider.getControl() instanceof Tree ? (Tree)this.provider.getControl() : null;
        Vector<TreeItem> items = ControlDragDrop.getTreeExpandedItems(tree);
        int i = 0;
        while (i < items.size()) {
            TreeItem item = items.get(i);
            Rectangle bounds = item.getBounds();
            Point p = tree.toDisplay(bounds.x, bounds.y);
            if (y >= p.y && y <= p.y + bounds.height) {
                return item;
            }
            ++i;
        }
        return null;
    }

    class DSL
    implements DragSourceListener {
        DSL() {
        }

        public void dragStart(DragSourceEvent e) {
            XModelObject o = ControlDragDrop.this.getLeadSelection();
            XModelObject[] targets = o == null ? null : ControlDragDrop.this.getMultiSelection();
            XModelTransferBuffer.getInstance().enable();
            boolean bl = e.doit = DnDUtil.isCopyEnabled(o, targets) && DnDUtil.copy(o, targets);
            if (e.doit) {
                ControlDragDrop.this.draggedObject = o;
            } else {
                XModelTransferBuffer.getInstance().disable();
            }
        }

        public void dragSetData(DragSourceEvent event) {
            if (ModelTransfer.getInstance().isSupportedType(event.dataType)) {
                XModelObject o = ControlDragDrop.this.getLeadSelection();
                event.data = o == null ? "" : o.getPresentationString();
            } else if (TextTransfer.getInstance().isSupportedType(event.dataType)) {
                XModelObject o = ControlDragDrop.this.getLeadSelection();
                event.data = o == null ? "" : o.getPresentationString();
            }
        }

        public void dragFinished(DragSourceEvent event) {
            XModelTransferBuffer.getInstance().disable();
            int cfr_ignored_0 = event.detail;
        }
    }

    class DTL
    implements DropTargetListener {
        private boolean isTextDrop = false;
        private boolean isPaletteDrop = false;
        private Scroller scroller;
        private Widget lastItem;

        DTL() {
            this.scroller = new Scroller();
            this.lastItem = null;
        }

        public void dragEnter(DropTargetEvent event) {
            this.scroller.start();
        }

        public void dragOver(DropTargetEvent event) {
            if (event.item != null && this.lastItem != event.item) {
                this.lastItem = event.item;
            }
            this.scroller.update(event.item, event.x, event.y);
            XModelObject o = ControlDragDrop.this.getModelObjectForWidget(event.item);
            if (o == null) {
                event.detail = 0;
                return;
            }
            boolean enabled = DnDUtil.isPasteEnabled(o);
            this.isTextDrop = false;
            this.isPaletteDrop = false;
            Properties p = ControlDragDrop.this.provider.getDropProperties(event.x, event.y);
            if (p != null && "none".equals(p.getProperty("text-context"))) {
                enabled = false;
            } else if (!enabled && o.isObjectEditable() && p != null && "true".equals(p.getProperty("accepsAsString"))) {
                if (this.isAdoptableMacro(o)) {
                    this.isPaletteDrop = true;
                } else {
                    this.isTextDrop = true;
                }
                enabled = true;
            }
            event.detail = enabled ? 2 : 0;
        }

        boolean isAdoptableMacro(XModelObject target) {
            if (paletteAdopt == null) {
                return false;
            }
            if (target.getFileType() != 1) {
                return false;
            }
            XModelObject source = target.getModel().getModelBuffer().source();
            if (source == null) {
                return false;
            }
            return paletteAdopt.isAdoptable(target, source);
        }

        public void dragLeave(DropTargetEvent event) {
            this.scroller.stop();
        }

        public void dragOperationChanged(DropTargetEvent event) {
        }

        public void dropAccept(DropTargetEvent event) {
        }

        public void drop(DropTargetEvent event) {
            XModelObject o;
            this.scroller.stop();
            Widget w = event.item;
            if (ControlDragDrop.this.provider instanceof TreeViewerDragDropProvider) {
                w = this.lastItem;
            }
            if ((o = ControlDragDrop.this.getModelObjectForWidget(w)) == null) {
                return;
            }
            try {
                Properties p = ControlDragDrop.this.provider.getDropProperties(event.x, event.y);
                if (p == null) {
                    p = new Properties();
                }
                p.setProperty("isDrop", "true");
                if (this.isTextDrop) {
                    XModelObject s = o.getModel().getModelBuffer().source();
                    if (s == null) {
                        return;
                    }
                    p.put("start text", s.getPresentationString());
                } else if (this.isPaletteDrop) {
                    paletteAdopt.adopt(o, o.getModel().getModelBuffer().source(), p);
                } else if (DnDUtil.isPasteEnabled(o)) {
                    DnDUtil.paste(o, p);
                }
                if (ControlDragDrop.this.provider instanceof IControlDropListener) {
                    p.put("drop.x", (Object)event.x);
                    p.put("drop.y", (Object)event.y);
                    if (ControlDragDrop.this.draggedObject != null) {
                        p.put("draggedObject", ControlDragDrop.this.draggedObject);
                    }
                    ((IControlDropListener)((Object)ControlDragDrop.this.provider)).drop(p);
                }
            }
            catch (ActionDeclinedException actionDeclinedException) {
                ControlDragDrop.this.ignore();
            }
            catch (XModelException e) {
                ModelUIPlugin.getPluginLog().logError((Throwable)e);
            }
        }
    }

    class Scroller
    implements Runnable {
        private long border_time = -1L;
        private int border = -1;
        private long item_time = -1L;
        private Widget item = null;
        int status = 0;
        boolean scrollPending = false;
        boolean expandPending = false;
        Widget lastItem = null;

        Scroller() {
        }

        public void run() {
            while (this.status == 1) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    ControlDragDrop.this.ignore();
                }
                long t = System.currentTimeMillis();
                if (this.item != null && t > this.item_time) {
                    this.expandPending = true;
                    this.item_time = -1L;
                }
                if (this.border == -1 || t <= this.border_time) continue;
                this.border_time += 500L;
                this.scrollPending = true;
            }
            this.status = 0;
        }

        public void start() {
            if (this.status == 0) {
                this.status = 1;
                new Thread(this).start();
            }
        }

        public void stop() {
            this.status = 2;
        }

        public void update(Widget w, int x, int y) {
            Scrollable sc;
            if (w != null && this.lastItem != w) {
                this.lastItem = w;
            }
            if (this.scrollPending) {
                this.fireScroll();
            }
            if (this.expandPending) {
                this.fireExpand();
            }
            if (w != this.item) {
                this.item = w;
                if (this.item != null) {
                    this.item_time = System.currentTimeMillis() + 1500L;
                }
            }
            Scrollable scrollable = sc = ControlDragDrop.this.provider.getControl() instanceof Scrollable ? (Scrollable)ControlDragDrop.this.provider.getControl() : null;
            if (sc == null) {
                return;
            }
            Rectangle c = sc.getClientArea();
            int yp_t = sc.toDisplay((Point)new Point((int)c.x, (int)c.y)).y;
            int yp_b = yp_t + c.height;
            if (yp_t < y && yp_t + 20 > y) {
                if (this.border != 1) {
                    this.border = 1;
                    this.border_time = System.currentTimeMillis() + 500L;
                }
            } else if (y < yp_b && y + 20 > yp_b) {
                if (this.border != 2) {
                    this.border = 2;
                    this.border_time = System.currentTimeMillis() + 500L;
                }
            } else if (this.border != -1) {
                this.border = -1;
                this.border_time = -1L;
            }
        }

        protected void fireExpand() {
            this.expandPending = false;
            if (!(this.item instanceof TreeItem)) {
                return;
            }
            if (ControlDragDrop.this.provider instanceof TreeViewerDragDropProvider) {
                TreeViewerDragDropProvider p = (TreeViewerDragDropProvider)ControlDragDrop.this.provider;
                p.expand(this.item);
            }
        }

        protected void fireScroll() {
            TreeItem i2;
            Scrollable sc;
            this.scrollPending = false;
            if (!(ControlDragDrop.this.provider.getControl() instanceof Tree) || this.lastItem == null) {
                return;
            }
            Tree tree = (Tree)ControlDragDrop.this.provider.getControl();
            TreeItem i = (TreeItem)this.lastItem;
            Scrollable scrollable = sc = ControlDragDrop.this.provider.getControl() instanceof Scrollable ? (Scrollable)ControlDragDrop.this.provider.getControl() : null;
            if (sc == null || sc.getVerticalBar() == null) {
                return;
            }
            if (this.border == 1 && sc != null) {
                TreeItem i22 = this.getPrevTreeItem(tree, i);
                if (i22 != null) {
                    tree.showItem(i22);
                }
            } else if (this.border == 2 && sc != null && (i2 = this.getNextTreeItem(tree, i)) != null) {
                tree.showItem(i2);
            }
        }

        private TreeItem getNextTreeItem(Tree tree, TreeItem item) {
            TreeItem result = null;
            Vector rows = ControlDragDrop.getTreeExpandedItems(tree);
            int index = rows.indexOf(item);
            result = index > -1 ? (index + 1 < rows.size() ? (TreeItem)rows.get(index + 1) : item) : item;
            return result;
        }

        private TreeItem getPrevTreeItem(Tree tree, TreeItem item) {
            TreeItem result = null;
            Vector rows = ControlDragDrop.getTreeExpandedItems(tree);
            int index = rows.indexOf(item);
            result = index > 0 ? (TreeItem)rows.get(index - 1) : item;
            return result;
        }
    }
}

