/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.utils;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.hibernate.console.ImageMap;
import org.hibernate.eclipse.console.HibernateConsolePlugin;

public class EclipseImageMap
extends ImageMap {
    protected URL ICON_BASE_URL = null;
    Map<String, ImageDescriptor> imageDescriptors = new HashMap<String, ImageDescriptor>();
    ImageRegistry imageRegistry = new ImageRegistry();

    public EclipseImageMap(Plugin plugin) {
        String pathSuffix = "icons/";
        try {
            this.ICON_BASE_URL = new URL(plugin.getBundle().getEntry("/"), pathSuffix);
        }
        catch (MalformedURLException malformedURLException) {}
        this.declareImages();
    }

    protected void declareRegistryImage(String key, String path) {
        ImageDescriptor desc = ImageDescriptor.getMissingImageDescriptor();
        try {
            desc = ImageDescriptor.createFromURL((URL)this.makeIconFileURL(path));
        }
        catch (MalformedURLException me) {
            HibernateConsolePlugin.getDefault().log(me);
        }
        this.imageRegistry.put(key, desc);
        this.imageDescriptors.put(key, desc);
    }

    protected URL makeIconFileURL(String iconPath) throws MalformedURLException {
        if (this.ICON_BASE_URL == null) {
            throw new MalformedURLException();
        }
        return new URL(this.ICON_BASE_URL, iconPath);
    }

    public Image getImage(String key) {
        return this.imageRegistry.get(key);
    }

    public ImageDescriptor getImageDescriptor(String key) {
        return this.imageDescriptors.get(key);
    }
}

