/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.graph.model;

import org.hibernate.eclipse.graph.model.ConfigurationViewAdapter;
import org.hibernate.eclipse.graph.model.GraphNode;
import org.hibernate.eclipse.graph.model.InheritanceViewAdapter;
import org.hibernate.mapping.PersistentClass;

public class PersistentClassViewAdapter
extends GraphNode {
    private PersistentClass persistentClass;
    private final ConfigurationViewAdapter configuration;

    public PersistentClassViewAdapter(ConfigurationViewAdapter configuration, PersistentClass clazz) {
        this.configuration = configuration;
        this.persistentClass = clazz;
    }

    public PersistentClass getPersistentClass() {
        return this.persistentClass;
    }

    public ConfigurationViewAdapter getConfiguration() {
        return this.configuration;
    }

    private void createInheritanceAssociations() {
        PersistentClass superclass = this.getPersistentClass().getSuperclass();
        if (superclass != null) {
            PersistentClassViewAdapter target = this.getConfiguration().getPersistentClassViewAdapter(superclass.getEntityName());
            InheritanceViewAdapter iva = new InheritanceViewAdapter(this, target);
            this.addSourceAssociation(iva);
            target.addTargetAssociation(iva);
        }
    }

    public String toString() {
        return "PersistentClassAdapter: " + this.persistentClass;
    }

    public void createAssociations() {
        this.createInheritanceAssociations();
    }
}

