/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.graph.parts;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPolicy;
import org.hibernate.eclipse.console.workbench.HibernateWorkbenchHelper;
import org.hibernate.eclipse.graph.figures.PersistentClassFigure;
import org.hibernate.eclipse.graph.model.PersistentClassViewAdapter;
import org.hibernate.eclipse.graph.model.PropertyViewAdapter;
import org.hibernate.eclipse.graph.parts.GraphNodeEditPart;
import org.hibernate.eclipse.graph.policy.PersistentClassLayoutPolicy;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentClassEditPart
extends GraphNodeEditPart {
    public PersistentClassEditPart(PersistentClassViewAdapter model) {
        this.setModel(model);
    }

    @Override
    protected void createEditPolicies() {
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new PersistentClassLayoutPolicy());
    }

    @Override
    public void refreshVisuals() {
        PersistentClassFigure myFigure = (PersistentClassFigure)this.getFigure();
        myFigure.refreshLabel(this.getHeaderName());
        super.refreshVisuals();
    }

    @Override
    protected IFigure createFigure() {
        String unqualify = this.getHeaderName();
        return new PersistentClassFigure(unqualify);
    }

    private String getHeaderName() {
        return HibernateWorkbenchHelper.getLabelForClassName(this.getPersistentClass().getEntityName());
    }

    protected List<PropertyViewAdapter> getModelChildren() {
        ArrayList<PropertyViewAdapter> list = new ArrayList<PropertyViewAdapter>();
        Property identifierProperty = this.getPersistentClass().getIdentifierProperty();
        if (identifierProperty != null) {
            list.add(new PropertyViewAdapter(this.getPersistentClassViewAdapter(), identifierProperty));
        }
        Iterator propertyIterator = this.getPersistentClass().getPropertyIterator();
        while (propertyIterator.hasNext()) {
            list.add(new PropertyViewAdapter(this.getPersistentClassViewAdapter(), (Property)propertyIterator.next()));
        }
        return list;
    }

    private PersistentClass getPersistentClass() {
        return this.getPersistentClassViewAdapter().getPersistentClass();
    }

    public PersistentClassViewAdapter getPersistentClassViewAdapter() {
        return (PersistentClassViewAdapter)this.getModel();
    }

    public IFigure getContentPane() {
        PersistentClassFigure figure = (PersistentClassFigure)this.getFigure();
        return figure.getPropertiesFigure();
    }
}

