/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.launch.core.refactoring;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.osgi.util.NLS;
import org.hibernate.eclipse.console.HibernateConsoleMessages;
import org.hibernate.eclipse.launch.core.refactoring.HibernateRefactoringUtil;

public class LaunchConfigurationResourceNameChange
extends Change {
    private ILaunchConfiguration fLaunchConfiguration;
    private IPath fOldPath;
    private IPath fNewPath;

    LaunchConfigurationResourceNameChange(ILaunchConfiguration launchConfiguration, IPath oldPath, IPath newPath) {
        this.fLaunchConfiguration = launchConfiguration;
        this.fOldPath = oldPath;
        this.fNewPath = newPath;
    }

    public Object getModifiedElement() {
        return this.fLaunchConfiguration;
    }

    public String getName() {
        return NLS.bind((String)HibernateConsoleMessages.LaunchConfigurationResourceNameChange_update_resource_path_in_launch_cfg, (Object)this.fLaunchConfiguration.getName());
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        if (!this.fLaunchConfiguration.exists()) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRoot root = workspace.getRoot();
            IPath rootLoacation = root.getLocation();
            IPath oldConfigLocationPath = this.fLaunchConfiguration.getLocation();
            if (oldConfigLocationPath == null && this.fLaunchConfiguration.getFile() != null) {
                oldConfigLocationPath = this.fLaunchConfiguration.getFile().getFullPath();
            }
            if (oldConfigLocationPath != null) {
                IPath newLaunchPath;
                IFile file;
                int matchSegment = oldConfigLocationPath.matchingFirstSegments(rootLoacation);
                IPath relativePath = oldConfigLocationPath.removeFirstSegments(matchSegment);
                if (HibernateRefactoringUtil.isAttributeChanged((relativePath = relativePath.setDevice(null).makeAbsolute()).toOSString(), this.fOldPath) && (file = root.getFileForLocation(rootLoacation.append(newLaunchPath = this.fNewPath.append(relativePath.removeFirstSegments(matchSegment = relativePath.matchingFirstSegments(this.fOldPath)))))) != null) {
                    this.fLaunchConfiguration = DebugPlugin.getDefault().getLaunchManager().getLaunchConfiguration(file);
                }
            }
        }
        this.fLaunchConfiguration = HibernateRefactoringUtil.updateConsoleConfig(this.fLaunchConfiguration, this.fOldPath, this.fNewPath);
        return new LaunchConfigurationResourceNameChange(this.fLaunchConfiguration, this.fNewPath, this.fOldPath);
    }
}

