/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.ui.diagram.rulers;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.rulers.RulerChangeListener;
import org.eclipse.gef.rulers.RulerProvider;
import org.jboss.tools.hibernate.ui.diagram.editors.command.CreateGuideCommand;
import org.jboss.tools.hibernate.ui.diagram.editors.command.DeleteGuideCommand;
import org.jboss.tools.hibernate.ui.diagram.editors.command.MoveGuideCommand;
import org.jboss.tools.hibernate.ui.diagram.editors.model.OrmShape;
import org.jboss.tools.hibernate.ui.diagram.rulers.DiagramGuide;
import org.jboss.tools.hibernate.ui.diagram.rulers.DiagramRuler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagramRulerProvider
extends RulerProvider {
    private DiagramRuler ruler;
    private PropertyChangeListener rulerListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("children changed")) {
                DiagramGuide guide = (DiagramGuide)evt.getNewValue();
                if (DiagramRulerProvider.this.getGuides().contains(guide)) {
                    guide.addPropertyChangeListener(DiagramRulerProvider.this.guideListener);
                } else {
                    guide.removePropertyChangeListener(DiagramRulerProvider.this.guideListener);
                }
                int i = 0;
                while (i < DiagramRulerProvider.this.listeners.size()) {
                    ((RulerChangeListener)DiagramRulerProvider.this.listeners.get(i)).notifyGuideReparented((Object)guide);
                    ++i;
                }
            } else {
                int i = 0;
                while (i < DiagramRulerProvider.this.listeners.size()) {
                    ((RulerChangeListener)DiagramRulerProvider.this.listeners.get(i)).notifyUnitsChanged(DiagramRulerProvider.this.ruler.getUnit());
                    ++i;
                }
            }
        }
    };
    private PropertyChangeListener guideListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("subparts changed")) {
                int i = 0;
                while (i < DiagramRulerProvider.this.listeners.size()) {
                    ((RulerChangeListener)DiagramRulerProvider.this.listeners.get(i)).notifyPartAttachmentChanged(evt.getNewValue(), evt.getSource());
                    ++i;
                }
            } else {
                int i = 0;
                while (i < DiagramRulerProvider.this.listeners.size()) {
                    ((RulerChangeListener)DiagramRulerProvider.this.listeners.get(i)).notifyGuideMoved(evt.getSource());
                    ++i;
                }
            }
        }
    };

    public DiagramRulerProvider(DiagramRuler ruler) {
        this.ruler = ruler;
        this.ruler.addPropertyChangeListener(this.rulerListener);
        List<DiagramGuide> guides = this.getGuides();
        int i = 0;
        while (i < guides.size()) {
            guides.get(i).addPropertyChangeListener(this.guideListener);
            ++i;
        }
    }

    public List<OrmShape> getAttachedModelObjects(Object guide) {
        return new ArrayList<OrmShape>(((DiagramGuide)guide).getParts());
    }

    public Command getCreateGuideCommand(int position) {
        return new CreateGuideCommand(this.ruler, position);
    }

    public Command getDeleteGuideCommand(Object guide) {
        return new DeleteGuideCommand((DiagramGuide)guide, this.ruler);
    }

    public Command getMoveGuideCommand(Object guide, int pDelta) {
        return new MoveGuideCommand((DiagramGuide)guide, pDelta);
    }

    public int[] getGuidePositions() {
        List<DiagramGuide> guides = this.getGuides();
        int[] result = new int[guides.size()];
        int i = 0;
        while (i < guides.size()) {
            result[i] = guides.get(i).getPosition();
            ++i;
        }
        return result;
    }

    public Object getRuler() {
        return this.ruler;
    }

    public int getUnit() {
        return this.ruler.getUnit();
    }

    public void setUnit(int newUnit) {
        this.ruler.setUnit(newUnit);
    }

    public int getGuidePosition(Object guide) {
        return ((DiagramGuide)guide).getPosition();
    }

    public List<DiagramGuide> getGuides() {
        return this.ruler.getGuides();
    }
}

