/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.pmd.eclipse.ui.model.AbstractPMDRecord;
import net.sourceforge.pmd.eclipse.ui.model.FileRecord;
import net.sourceforge.pmd.eclipse.ui.model.FileToMarkerRecord;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;

public class MarkerRecord
extends AbstractPMDRecord {
    private AbstractPMDRecord[] children;
    private final FileRecord parent;
    private final String ruleName;
    private final int priority;
    private final List markers;

    public MarkerRecord(FileRecord fileRecord, String string, int n) {
        this.parent = fileRecord;
        this.ruleName = string;
        this.priority = n;
        this.markers = new ArrayList();
        this.children = AbstractPMDRecord.EMPTY_RECORDS;
    }

    public void addViolation(IMarker iMarker) {
        this.markers.add(iMarker);
    }

    public int getViolationsCounted() {
        return this.markers.size();
    }

    public AbstractPMDRecord addResource(IResource iResource) {
        return null;
    }

    public void updateChildren() {
        this.children = this.createChildren();
    }

    public final AbstractPMDRecord[] createChildren() {
        ArrayList<FileToMarkerRecord> arrayList = new ArrayList<FileToMarkerRecord>();
        List list = this.parent.getParent().findResourcesByName(this.ruleName, 16);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            MarkerRecord markerRecord = (MarkerRecord)iterator.next();
            arrayList.add(new FileToMarkerRecord(markerRecord));
        }
        return arrayList.toArray(new AbstractPMDRecord[arrayList.size()]);
    }

    public AbstractPMDRecord[] getChildren() {
        return this.children;
    }

    public String getName() {
        return this.ruleName;
    }

    public int getPriority() {
        return this.priority;
    }

    public AbstractPMDRecord getParent() {
        return this.parent;
    }

    public IResource getResource() {
        return this.parent.getResource();
    }

    public int getResourceType() {
        return 16;
    }

    public AbstractPMDRecord removeResource(IResource iResource) {
        return null;
    }

    public boolean hasMarkers() {
        return this.markers.size() > 0;
    }

    public IMarker[] findMarkers() {
        return this.markers.toArray(new IMarker[this.markers.size()]);
    }

    public int getNumberOfViolationsToPriority(int n, boolean bl) {
        int n2 = 0;
        if (n == this.priority) {
            if (bl) {
                int n3 = 0;
                while (n3 < this.children.length) {
                    n2 += this.children[n3].getNumberOfViolationsToPriority(n, false);
                    ++n3;
                }
            } else {
                n2 = this.getViolationsCounted();
            }
        }
        return n2;
    }

    public int getLOC() {
        return this.parent.getLOC();
    }

    public int getNumberOfMethods() {
        return this.parent.getNumberOfMethods();
    }
}

