/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.preferences;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Comparator;
import java.util.Iterator;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.runtime.writer.IRuleSetWriter;
import net.sourceforge.pmd.eclipse.runtime.writer.WriterException;
import net.sourceforge.pmd.eclipse.ui.preferences.RuleCellModifier;
import net.sourceforge.pmd.eclipse.ui.preferences.RuleDialog;
import net.sourceforge.pmd.eclipse.ui.preferences.RuleLabelProvider;
import net.sourceforge.pmd.eclipse.ui.preferences.RulePropertiesContentProvider;
import net.sourceforge.pmd.eclipse.ui.preferences.RulePropertyCellModifier;
import net.sourceforge.pmd.eclipse.ui.preferences.RulePropertyLabelProvider;
import net.sourceforge.pmd.eclipse.ui.preferences.RuleSetContentProvider;
import net.sourceforge.pmd.eclipse.ui.preferences.RuleSetExcludeIncludePatternCellModifier;
import net.sourceforge.pmd.eclipse.ui.preferences.RuleSetExcludeIncludePatternContentProvider;
import net.sourceforge.pmd.eclipse.ui.preferences.RuleSetExcludeIncludePatternLabelProvider;
import net.sourceforge.pmd.eclipse.ui.preferences.RuleSetSelectionDialog;
import net.sourceforge.pmd.eclipse.ui.preferences.RuleTableViewerSorter;
import net.sourceforge.pmd.util.designer.Designer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class PMDPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String PROPERTY_RULESET_NAME = "ruleSetname";
    public static final String PROPERTY_RULE_NAME = "ruleName";
    public static final String PROPERTY_SINCE = "since";
    public static final String PROPERTY_PRIORITY = "priority";
    public static final String PROPERTY_DESCRIPTION = "description";
    public static final String PROPERTY_PROPERTY = "property";
    public static final String PROPERTY_VALUE = "value";
    public static final String PROPERTY_PATTERN = "pattern";
    public static PMDPreferencePage activeInstance = null;
    protected TableViewer ruleTableViewer;
    protected TableViewer rulePropertiesTableViewer;
    protected TableViewer excludePatternTableViewer;
    protected TableViewer includePatternTableViewer;
    protected Button addRuleButton;
    protected Button removeRuleButton;
    protected Button editRuleButton;
    protected Button addPropertyButton;
    protected Button addExcludePatternButton;
    protected Button addIncludePatternButton;
    protected RuleSet ruleSet;
    private boolean modified = false;
    private final RuleTableViewerSorter ruleTableViewerSorter = new RuleTableViewerSorter(RuleTableViewerSorter.RULE_DEFAULT_COMPARATOR);

    public void init(IWorkbench iWorkbench) {
        this.setDescription(this.getMessage("preference.ruleset.title"));
        activeInstance = this;
    }

    protected void performDefaults() {
        this.populateRuleTable();
        this.populateExcludePatternTable();
        this.populateIncludePatternTable();
        super.performDefaults();
    }

    public boolean performOk() {
        if (this.modified) {
            this.updateRuleSet();
            this.rebuildProjects();
        }
        return super.performOk();
    }

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        this.layoutControls(composite2);
        return composite2;
    }

    private void layoutControls(Composite composite) {
        Label label = this.buildLabel(composite, "preference.ruleset.label.ruletable");
        Table table = this.buildRuleTableViewer(composite);
        Composite composite2 = this.buildRuleTableButtons(composite);
        Label label2 = this.buildLabel(composite, "preference.ruleset.label.rulepropstable");
        Table table2 = this.buildRulePropertiesTableViewer(composite);
        Composite composite3 = this.buildRulePropertiesTableButtons(composite);
        Label label3 = this.buildLabel(composite, "preference.ruleset.label.exclude_patterns_table");
        Label label4 = this.buildLabel(composite, "preference.ruleset.label.include_patterns_table");
        Table table3 = this.buildExcludePatternTableViewer(composite);
        Table table4 = this.buildIncludePatternTableViewer(composite);
        Composite composite4 = this.buildExcludeIncludePatternTableButtons(composite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.heightHint = 200;
        gridData.widthHint = 350;
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        table.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        composite2.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.verticalIndent = 5;
        label2.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = 50;
        gridData.widthHint = 500;
        table2.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        composite3.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.verticalIndent = 5;
        gridData.horizontalSpan = 1;
        label3.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.verticalIndent = 5;
        gridData.horizontalSpan = 2;
        label4.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.heightHint = 50;
        gridData.widthHint = 250;
        table3.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.heightHint = 50;
        gridData.widthHint = 250;
        table4.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        composite4.setLayoutData((Object)gridData);
    }

    private Composite buildRuleTableButtons(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.verticalSpacing = 3;
        composite2.setLayout((Layout)gridLayout);
        this.removeRuleButton = this.buildRemoveRuleButton(composite2);
        this.editRuleButton = this.buildEditRuleButton(composite2);
        this.addRuleButton = this.buildAddRuleButton(composite2);
        Button button = this.buildImportRuleSetButton(composite2);
        Button button2 = this.buildExportRuleSetButton(composite2);
        Button button3 = this.buildClearAllButton(composite2);
        Button button4 = this.buildRuleDesignerButton(composite2);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.removeRuleButton.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.editRuleButton.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.addRuleButton.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        button.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        button2.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        button3.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 3;
        button4.setLayoutData((Object)gridData);
        return composite2;
    }

    private Composite buildRulePropertiesTableButtons(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        RowLayout rowLayout = new RowLayout();
        rowLayout.type = 512;
        rowLayout.wrap = false;
        rowLayout.pack = false;
        composite2.setLayout((Layout)rowLayout);
        this.addPropertyButton = this.buildAddPropertyButton(composite2);
        return composite2;
    }

    private Label buildLabel(Composite composite, String string) {
        Label label = new Label(composite, 0);
        label.setText(string == null ? "" : this.getMessage(string));
        return label;
    }

    private void addColumnTo(Table table, int n, boolean bl, String string, int n2, final Comparator comparator) {
        TableColumn tableColumn = new TableColumn(table, n);
        tableColumn.setResizable(bl);
        tableColumn.setText(string);
        tableColumn.setWidth(n2);
        if (comparator != null) {
            tableColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    PMDPreferencePage.this.ruleTableViewerSorter.setComparator(comparator);
                    PMDPreferencePage.this.refresh();
                }
            });
        }
    }

    private Table buildRuleTableViewer(Composite composite) {
        int n = 68356;
        this.ruleTableViewer = new TableViewer(composite, n);
        Table table = this.ruleTableViewer.getTable();
        this.addColumnTo(table, 16384, true, this.getMessage("preference.ruleset.column.ruleset_name"), 110, RuleTableViewerSorter.RULE_RULESET_NAME_COMPARATOR);
        this.addColumnTo(table, 16384, true, this.getMessage("preference.ruleset.column.rule_name"), 170, RuleTableViewerSorter.RULE_NAME_COMPARATOR);
        this.addColumnTo(table, 16384, false, this.getMessage("preference.ruleset.column.since"), 40, RuleTableViewerSorter.RULE_SINCE_COMPARATOR);
        this.addColumnTo(table, 16384, false, this.getMessage("preference.ruleset.column.priority"), 80, RuleTableViewerSorter.RULE_PRIORITY_COMPARATOR);
        this.addColumnTo(table, 16384, true, this.getMessage("preference.ruleset.column.description"), 300, RuleTableViewerSorter.RULE_DESCRIPTION_COMPARATOR);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        this.ruleTableViewer.setContentProvider((IContentProvider)new RuleSetContentProvider());
        this.ruleTableViewer.setLabelProvider((IBaseLabelProvider)new RuleLabelProvider());
        this.ruleTableViewer.setSorter((ViewerSorter)this.ruleTableViewerSorter);
        this.ruleTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)selectionChangedEvent.getSelection();
                Rule rule = (Rule)iStructuredSelection.getFirstElement();
                PMDPreferencePage.this.rulePropertiesTableViewer.setInput((Object)rule);
                PMDPreferencePage.this.removeRuleButton.setEnabled(rule != null);
                PMDPreferencePage.this.editRuleButton.setEnabled(rule != null);
                PMDPreferencePage.this.addPropertyButton.setEnabled(rule != null);
            }
        });
        this.ruleTableViewer.setColumnProperties(new String[]{PROPERTY_RULESET_NAME, PROPERTY_RULE_NAME, PROPERTY_SINCE, PROPERTY_PRIORITY, PROPERTY_DESCRIPTION});
        this.ruleTableViewer.setCellModifier((ICellModifier)new RuleCellModifier(this.ruleTableViewer));
        CellEditor[] cellEditorArray = new CellEditor[5];
        cellEditorArray[3] = new ComboBoxCellEditor((Composite)table, PMDPlugin.getDefault().getPriorityLabels());
        cellEditorArray[4] = new TextCellEditor((Composite)table);
        this.ruleTableViewer.setCellEditors(cellEditorArray);
        this.populateRuleTable();
        return table;
    }

    private Table buildRulePropertiesTableViewer(Composite composite) {
        int n = 68356;
        this.rulePropertiesTableViewer = new TableViewer(composite, n);
        Table table = this.rulePropertiesTableViewer.getTable();
        TableColumn tableColumn = new TableColumn(table, 16384);
        tableColumn.setResizable(true);
        tableColumn.setText(this.getMessage("preference.ruleset.column.property"));
        tableColumn.setWidth(100);
        TableColumn tableColumn2 = new TableColumn(table, 16384);
        tableColumn2.setResizable(true);
        tableColumn2.setText(this.getMessage("preference.ruleset.column.value"));
        tableColumn2.setWidth(350);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        this.rulePropertiesTableViewer.setContentProvider((IContentProvider)new RulePropertiesContentProvider());
        this.rulePropertiesTableViewer.setLabelProvider((IBaseLabelProvider)new RulePropertyLabelProvider());
        this.rulePropertiesTableViewer.setColumnProperties(new String[]{PROPERTY_PROPERTY, PROPERTY_VALUE});
        this.rulePropertiesTableViewer.setCellModifier((ICellModifier)new RulePropertyCellModifier(this.rulePropertiesTableViewer));
        CellEditor[] cellEditorArray = new CellEditor[2];
        cellEditorArray[1] = new TextCellEditor((Composite)table);
        this.rulePropertiesTableViewer.setCellEditors(cellEditorArray);
        return table;
    }

    private Button buildRemoveRuleButton(Composite composite) {
        Button button = new Button(composite, 16392);
        button.setText(this.getMessage("preference.ruleset.button.removerule"));
        button.setEnabled(false);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)PMDPreferencePage.this.ruleTableViewer.getSelection();
                Rule rule = (Rule)iStructuredSelection.getFirstElement();
                PMDPreferencePage.this.ruleSet.getRules().remove(rule);
                PMDPreferencePage.this.setModified(true);
                try {
                    PMDPreferencePage.this.refresh();
                }
                catch (Throwable throwable) {
                    PMDPreferencePage.this.ruleTableViewer.setSelection(null);
                }
            }
        });
        return button;
    }

    private Button buildEditRuleButton(Composite composite) {
        Button button = new Button(composite, 16392);
        button.setText(this.getMessage("preference.ruleset.button.editrule"));
        button.setEnabled(false);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)PMDPreferencePage.this.ruleTableViewer.getSelection();
                Rule rule = (Rule)iStructuredSelection.getFirstElement();
                RuleDialog ruleDialog = new RuleDialog(PMDPreferencePage.this.getShell(), rule);
                int n = ruleDialog.open();
                if (n == 0) {
                    PMDPreferencePage.this.setModified(true);
                    try {
                        PMDPreferencePage.this.refresh();
                    }
                    catch (Throwable throwable) {
                        PMDPlugin.getDefault().logError("Exception when refreshing the rule table", throwable);
                    }
                }
            }
        });
        return button;
    }

    private Button buildAddRuleButton(Composite composite) {
        Button button = new Button(composite, 16392);
        button.setText(this.getMessage("preference.ruleset.button.addrule"));
        button.setEnabled(true);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                RuleDialog ruleDialog = new RuleDialog(PMDPreferencePage.this.getShell());
                int n = ruleDialog.open();
                if (n == 0) {
                    Rule rule = ruleDialog.getRule();
                    PMDPreferencePage.this.ruleSet.addRule(rule);
                    PMDPreferencePage.this.setModified(true);
                    try {
                        PMDPreferencePage.this.refresh();
                    }
                    catch (Throwable throwable) {
                        PMDPlugin.getDefault().logError("Exception when refreshing the rule table", throwable);
                    }
                    PMDPreferencePage.this.setModified(true);
                    try {
                        PMDPreferencePage.this.refresh();
                    }
                    catch (Throwable throwable) {
                        PMDPlugin.getDefault().logError("Exception when refreshing the rule table", throwable);
                    }
                }
            }
        });
        return button;
    }

    private Button buildImportRuleSetButton(Composite composite) {
        Button button = new Button(composite, 16392);
        button.setText(this.getMessage("preference.ruleset.button.importruleset"));
        button.setEnabled(true);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                RuleSetSelectionDialog ruleSetSelectionDialog = new RuleSetSelectionDialog(PMDPreferencePage.this.getShell());
                ruleSetSelectionDialog.open();
                if (ruleSetSelectionDialog.getReturnCode() == 0) {
                    try {
                        RuleSet ruleSet = ruleSetSelectionDialog.getSelectedRuleSet();
                        if (ruleSetSelectionDialog.isImportByReference()) {
                            PMDPreferencePage.this.ruleSet.addRuleSetByReference(ruleSet, false);
                        } else {
                            Iterator iterator = ruleSet.getRules().iterator();
                            while (iterator.hasNext()) {
                                Rule rule = (Rule)iterator.next();
                                rule.setRuleSetName("pmd-eclipse");
                                PMDPreferencePage.this.ruleSet.addRule(rule);
                            }
                        }
                        PMDPreferencePage.this.setModified(true);
                        try {
                            PMDPreferencePage.this.refresh();
                        }
                        catch (Throwable throwable) {
                            PMDPlugin.getDefault().logError("Exception when refreshing the rule table", throwable);
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        PMDPlugin.getDefault().showError(PMDPreferencePage.this.getMessage("message.error.importing_ruleset"), runtimeException);
                    }
                }
            }
        });
        return button;
    }

    private Button buildExportRuleSetButton(Composite composite) {
        Button button = new Button(composite, 16392);
        button.setText(this.getMessage("preference.ruleset.button.exportruleset"));
        button.setEnabled(true);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileDialog fileDialog = new FileDialog(PMDPreferencePage.this.getShell(), 8192);
                String string = fileDialog.open();
                if (string != null) {
                    try {
                        File file = new File(string);
                        boolean bl = true;
                        if (file.exists()) {
                            bl = MessageDialog.openConfirm((Shell)PMDPreferencePage.this.getShell(), (String)PMDPreferencePage.this.getMessage("message.confirm.title"), (String)PMDPreferencePage.this.getMessage("message.confirm.ruleset_exists"));
                        }
                        InputDialog inputDialog = null;
                        if (bl) {
                            inputDialog = new InputDialog(PMDPreferencePage.this.getShell(), PMDPreferencePage.this.getMessage("preference.ruleset.dialog.title"), PMDPreferencePage.this.getMessage("preference.ruleset.dialog.ruleset_description"), PMDPreferencePage.this.ruleSet.getDescription() == null ? "" : PMDPreferencePage.this.ruleSet.getDescription().trim(), null);
                            boolean bl2 = bl = inputDialog.open() == 0;
                        }
                        if (bl) {
                            PMDPreferencePage.this.ruleSet.setName(PMDPreferencePage.this.getFileNameWithoutExtension(file.getName()));
                            PMDPreferencePage.this.ruleSet.setDescription(inputDialog.getValue());
                            FileOutputStream fileOutputStream = new FileOutputStream(string);
                            IRuleSetWriter iRuleSetWriter = PMDPlugin.getDefault().getRuleSetWriter();
                            iRuleSetWriter.write(fileOutputStream, PMDPreferencePage.this.ruleSet);
                            ((OutputStream)fileOutputStream).close();
                            MessageDialog.openInformation((Shell)PMDPreferencePage.this.getShell(), (String)PMDPreferencePage.this.getMessage("message.information.title"), (String)PMDPreferencePage.this.getMessage("message.information.ruleset_exported"));
                        }
                    }
                    catch (IOException iOException) {
                        PMDPlugin.getDefault().showError(PMDPreferencePage.this.getMessage("message.error.exporting_ruleset"), iOException);
                    }
                    catch (WriterException writerException) {
                        PMDPlugin.getDefault().showError(PMDPreferencePage.this.getMessage("message.error.exporting_ruleset"), writerException);
                    }
                }
            }
        });
        return button;
    }

    private Button buildClearAllButton(Composite composite) {
        Button button = new Button(composite, 16392);
        button.setText(this.getMessage("preference.ruleset.button.clearall"));
        button.setEnabled(true);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (MessageDialog.openConfirm((Shell)PMDPreferencePage.this.getShell(), (String)PMDPreferencePage.this.getMessage("message.confirm.title"), (String)PMDPreferencePage.this.getMessage("message.confirm.clear_ruleset"))) {
                    PMDPreferencePage.this.ruleSet.getRules().clear();
                    PMDPreferencePage.this.setModified(true);
                    try {
                        PMDPreferencePage.this.refresh();
                    }
                    catch (Throwable throwable) {
                        PMDPlugin.getDefault().logError("Exception when refreshing the rule table", throwable);
                    }
                }
            }
        });
        return button;
    }

    private Button buildRuleDesignerButton(Composite composite) {
        Button button = new Button(composite, 16392);
        button.setText(this.getMessage("preference.ruleset.button.ruledesigner"));
        button.setEnabled(true);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                new Thread(new Runnable(this){
                    final /* synthetic */ 9 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        Designer.main((String[])new String[]{"-noexitonclose"});
                    }
                }).start();
            }
        });
        return button;
    }

    private Button buildAddPropertyButton(Composite composite) {
        Button button = new Button(composite, 16392);
        button.setText(this.getMessage("preference.ruleset.button.addproperty"));
        button.setEnabled(false);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                InputDialog inputDialog = new InputDialog(PMDPreferencePage.this.getShell(), PMDPreferencePage.this.getMessage("preference.ruleset.dialog.title"), PMDPreferencePage.this.getMessage("preference.ruleset.dialog.property_name"), "", null);
                int n = inputDialog.open();
                if (n == 0) {
                    IStructuredSelection iStructuredSelection = (IStructuredSelection)PMDPreferencePage.this.ruleTableViewer.getSelection();
                    Rule rule = (Rule)iStructuredSelection.getFirstElement();
                    rule.addProperty(inputDialog.getValue(), "");
                    PMDPreferencePage.this.setModified(true);
                    PMDPreferencePage.this.rulePropertiesTableViewer.refresh();
                }
            }
        });
        return button;
    }

    private Table buildExcludePatternTableViewer(Composite composite) {
        int n = 68356;
        this.excludePatternTableViewer = new TableViewer(composite, n);
        Table table = this.excludePatternTableViewer.getTable();
        TableColumn tableColumn = new TableColumn(table, 16384);
        tableColumn.setResizable(true);
        tableColumn.setText(this.getMessage("preference.ruleset.column.exclude_pattern"));
        tableColumn.setWidth(250);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        this.excludePatternTableViewer.setContentProvider((IContentProvider)new RuleSetExcludeIncludePatternContentProvider(true));
        this.excludePatternTableViewer.setLabelProvider((IBaseLabelProvider)new RuleSetExcludeIncludePatternLabelProvider());
        this.excludePatternTableViewer.setColumnProperties(new String[]{PROPERTY_PATTERN});
        this.excludePatternTableViewer.setCellModifier((ICellModifier)new RuleSetExcludeIncludePatternCellModifier(this.excludePatternTableViewer));
        this.excludePatternTableViewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)table)});
        this.populateExcludePatternTable();
        return table;
    }

    private Table buildIncludePatternTableViewer(Composite composite) {
        int n = 68356;
        this.includePatternTableViewer = new TableViewer(composite, n);
        Table table = this.includePatternTableViewer.getTable();
        TableColumn tableColumn = new TableColumn(table, 16384);
        tableColumn.setResizable(true);
        tableColumn.setText(this.getMessage("preference.ruleset.column.include_pattern"));
        tableColumn.setWidth(250);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        this.includePatternTableViewer.setContentProvider((IContentProvider)new RuleSetExcludeIncludePatternContentProvider(false));
        this.includePatternTableViewer.setLabelProvider((IBaseLabelProvider)new RuleSetExcludeIncludePatternLabelProvider());
        this.includePatternTableViewer.setColumnProperties(new String[]{PROPERTY_PATTERN});
        this.includePatternTableViewer.setCellModifier((ICellModifier)new RuleSetExcludeIncludePatternCellModifier(this.includePatternTableViewer));
        this.includePatternTableViewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)table)});
        this.populateIncludePatternTable();
        return table;
    }

    private Composite buildExcludeIncludePatternTableButtons(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        RowLayout rowLayout = new RowLayout();
        rowLayout.type = 512;
        rowLayout.wrap = false;
        rowLayout.pack = false;
        composite2.setLayout((Layout)rowLayout);
        this.addExcludePatternButton = this.buildAddExcludePatternButton(composite2);
        this.addIncludePatternButton = this.buildAddIncludePatternButton(composite2);
        return composite2;
    }

    private Button buildAddExcludePatternButton(Composite composite) {
        Button button = new Button(composite, 16392);
        button.setText(this.getMessage("preference.ruleset.button.add_exclude_pattern"));
        button.setEnabled(true);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PMDPreferencePage.this.ruleSet.addExcludePattern(".*/PATTERN/.*");
                PMDPreferencePage.this.setModified(true);
                PMDPreferencePage.this.excludePatternTableViewer.refresh();
            }
        });
        return button;
    }

    private Button buildAddIncludePatternButton(Composite composite) {
        Button button = new Button(composite, 16392);
        button.setText(this.getMessage("preference.ruleset.button.add_include_pattern"));
        button.setEnabled(true);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PMDPreferencePage.this.ruleSet.addIncludePattern(".*/PATTERN/.*");
                PMDPreferencePage.this.setModified(true);
                PMDPreferencePage.this.includePatternTableViewer.refresh();
            }
        });
        return button;
    }

    private static String asCleanString(String string) {
        return string == null ? "" : string.trim();
    }

    private void populateRuleTable() {
        RuleSet ruleSet = PMDPlugin.getDefault().getPreferencesManager().getRuleSet();
        this.ruleSet = new RuleSet();
        this.ruleSet.addRuleSet(ruleSet);
        this.ruleSet.setName(ruleSet.getName());
        this.ruleSet.setDescription(PMDPreferencePage.asCleanString(ruleSet.getDescription()));
        this.ruleSet.addExcludePatterns(ruleSet.getExcludePatterns());
        this.ruleSet.addIncludePatterns(ruleSet.getIncludePatterns());
        this.ruleTableViewer.setInput((Object)this.ruleSet);
    }

    private void populateExcludePatternTable() {
        this.excludePatternTableViewer.setInput((Object)this.ruleSet);
    }

    private void populateIncludePatternTable() {
        this.includePatternTableViewer.setInput((Object)this.ruleSet);
    }

    protected String getMessage(String string) {
        return PMDPlugin.getDefault().getStringTable().getString(string);
    }

    protected String getFileNameWithoutExtension(String string) {
        String string2 = string;
        int n = string.lastIndexOf(46);
        if (n != -1) {
            string2 = string.substring(0, n);
        }
        return string2;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return PMDPlugin.getDefault().getPreferenceStore();
    }

    public static PMDPreferencePage getActiveInstance() {
        return activeInstance;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean bl) {
        this.modified = bl;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void refresh() {
        try {
            try {
                this.ruleTableViewer.getControl().setRedraw(false);
                this.ruleTableViewer.refresh();
                this.rulePropertiesTableViewer.refresh();
                this.excludePatternTableViewer.refresh();
                this.includePatternTableViewer.refresh();
            }
            catch (ClassCastException classCastException) {
                PMDPlugin.getDefault().logError("Ignoring exception while refreshing table", classCastException);
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.ruleTableViewer.getControl().setRedraw(true);
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.ruleTableViewer.getControl().setRedraw(true);
    }

    private void updateRuleSet() {
        try {
            ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(this.getShell());
            progressMonitorDialog.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                    PMDPlugin.getDefault().getPreferencesManager().setRuleSet(PMDPreferencePage.this.ruleSet);
                }
            });
        }
        catch (InterruptedException interruptedException) {
            PMDPlugin.getDefault().logError("Exception updating all projects after a preference change", interruptedException);
        }
        catch (InvocationTargetException invocationTargetException) {
            PMDPlugin.getDefault().logError("Exception updating all projects after a preference change", invocationTargetException);
        }
    }

    private void rebuildProjects() {
        if (MessageDialog.openQuestion((Shell)this.getShell(), (String)this.getMessage("message.question.title"), (String)this.getMessage("message.question.rules_changed"))) {
            try {
                ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(this.getShell());
                progressMonitorDialog.run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                        try {
                            ResourcesPlugin.getWorkspace().build(6, iProgressMonitor);
                        }
                        catch (CoreException coreException) {
                            PMDPlugin.getDefault().logError("Exception building all projects after a preference change", coreException);
                        }
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                PMDPlugin.getDefault().logError("Exception building all projects after a preference change", interruptedException);
            }
            catch (InvocationTargetException invocationTargetException) {
                PMDPlugin.getDefault().logError("Exception building all projects after a preference change", invocationTargetException);
            }
        }
    }

    protected void selectAndShowRule(Rule rule) {
        Table table = this.ruleTableViewer.getTable();
        TableItem[] tableItemArray = table.getItems();
        int n = 0;
        while (n < tableItemArray.length) {
            Rule rule2 = (Rule)tableItemArray[n].getData();
            if (rule2.equals(rule)) {
                table.setSelection(table.indexOf(tableItemArray[n]));
                table.showSelection();
                break;
            }
            ++n;
        }
    }
}

