/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.cloud;

import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.cloud.BugCollectionStorageCloud;
import edu.umd.cs.findbugs.cloud.Cloud;
import java.lang.reflect.Constructor;

public class CloudFactory {
    private static final String DEFAULT_CLOUD_CLASS = "edu.umd.cs.findbugs.cloud.db.DBCloud";

    public static Cloud getCloud(BugCollection bc) {
        boolean cloudClassSpecified;
        String cloudClassName = SystemProperties.getProperty("findbugs.cloud.classname");
        boolean bl = cloudClassSpecified = cloudClassName != null;
        if (!cloudClassSpecified) {
            cloudClassName = DEFAULT_CLOUD_CLASS;
        }
        try {
            Class<Cloud> cloudClass = Class.forName(cloudClassName).asSubclass(Cloud.class);
            Constructor<Cloud> constructor = cloudClass.getConstructor(BugCollection.class);
            Cloud cloud = constructor.newInstance(bc);
            if (cloud.availableForInitialization()) {
                if (cloud.initialize()) {
                    return cloud;
                }
                bc.getProject().getGuiCallback().showMessageDialog("Unable to connect to " + cloudClass.getSimpleName());
                if (SystemProperties.getBoolean("findbugs.failIfUnableToConnectToDB")) {
                    System.exit(1);
                }
            } else if (cloudClassSpecified) {
                bc.getProject().getGuiCallback().showMessageDialog("Bad configuration for " + cloudClass.getSimpleName());
            }
        }
        catch (ClassNotFoundException e) {
            if (cloudClassSpecified) {
                bc.getProject().getGuiCallback().showMessageDialog("Unable to load cloud " + cloudClassName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return CloudFactory.getPlainCloud(bc);
    }

    public static Cloud getPlainCloud(BugCollection bc) {
        BugCollectionStorageCloud cloud = new BugCollectionStorageCloud(bc);
        cloud.initialize();
        return cloud;
    }
}

