/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.deref.UnconditionalValueDerefDataflow;
import edu.umd.cs.findbugs.ba.deref.UnconditionalValueDerefSet;
import edu.umd.cs.findbugs.ba.npe.IsNullValue;
import edu.umd.cs.findbugs.ba.npe.IsNullValueDataflow;
import edu.umd.cs.findbugs.ba.npe.IsNullValueFrame;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.ba.vna.ValueNumberDataflow;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFrame;
import edu.umd.cs.findbugs.ba.vna.ValueNumberSourceInfo;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.generic.IfInstruction;
import org.apache.bcel.generic.InstructionHandle;

public class FindNullDerefsInvolvingNonShortCircuitEvaluation
extends OpcodeStackDetector {
    private static boolean DEBUG = false;
    BugReporter bugReporter;

    public FindNullDerefsInvolvingNonShortCircuitEvaluation(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visit(Code code) {
        boolean interesting = true;
        if (interesting) {
            super.visit(code);
        }
    }

    public void sawOpcode(int seen) {
        int nextOpcode;
        if (!(seen != 126 && seen != 128 || (nextOpcode = this.getCodeByte(this.getPC() + 1)) != 153 && nextOpcode != 154)) {
            OpcodeStack.Item left = this.stack.getStackItem(1);
            OpcodeStack.Item right = this.stack.getStackItem(0);
            this.checkForNullForcingABranch(seen, nextOpcode, left);
            this.checkForNullForcingABranch(seen, nextOpcode, right);
        }
    }

    private void checkForNullForcingABranch(int seen, int nextOpcode, OpcodeStack.Item item) {
        if (this.nullGuaranteesBranch(seen, item)) {
            boolean nullGuaranteesZero = seen == 126;
            boolean nullGuaranteesBranch = nullGuaranteesZero ^ nextOpcode == 154;
            if (DEBUG) {
                System.out.println(item.getPC() + " null guarantees " + nullGuaranteesBranch + " branch");
            }
            try {
                Location guaranteed;
                CFG cfg = this.getClassContext().getCFG(this.getMethod());
                Location produced = this.findLocation(cfg, item.getPC());
                Location branch = this.findLocation(cfg, this.getPC() + 1);
                if (produced == null || branch == null) {
                    return;
                }
                IfInstruction branchInstruction = (IfInstruction)branch.getHandle().getInstruction();
                IsNullValueDataflow isNullValueDataflow = this.getClassContext().getIsNullValueDataflow(this.getMethod());
                ValueNumberDataflow valueNumberDataflow = this.getClassContext().getValueNumberDataflow(this.getMethod());
                UnconditionalValueDerefDataflow unconditionalValueDerefDataflow = this.getClassContext().getUnconditionalValueDerefDataflow(this.getMethod());
                ValueNumberFrame valueNumberFact = (ValueNumberFrame)valueNumberDataflow.getFactAtLocation(produced);
                IsNullValueFrame isNullFact = (IsNullValueFrame)isNullValueDataflow.getFactAtLocation(produced);
                ValueNumber value = (ValueNumber)valueNumberFact.getTopValue();
                if (((IsNullValue)isNullFact.getTopValue()).isDefinitelyNotNull()) {
                    return;
                }
                if (DEBUG) {
                    System.out.println("Produced: " + produced);
                    System.out.println(valueNumberFact);
                    System.out.println(isNullFact);
                    System.out.println("value: " + value);
                    System.out.println("branch: " + branch);
                    System.out.println("instruction: " + branchInstruction);
                    System.out.println("target: " + branchInstruction.getTarget());
                    System.out.println("next: " + branch.getHandle().getNext());
                }
                if ((guaranteed = this.findLocation(cfg, nullGuaranteesBranch ? branchInstruction.getTarget() : branch.getHandle().getNext())) == null) {
                    return;
                }
                UnconditionalValueDerefSet unconditionalDeref = (UnconditionalValueDerefSet)unconditionalValueDerefDataflow.getFactAtLocation(guaranteed);
                if (DEBUG) {
                    System.out.println("Guaranteed on null: " + guaranteed);
                    System.out.println(unconditionalDeref);
                }
                if (unconditionalDeref.isUnconditionallyDereferenced(value)) {
                    BugInstance bug;
                    SourceLineAnnotation tested = SourceLineAnnotation.fromVisitedInstruction(this.getClassContext(), this.getMethod(), produced);
                    BugAnnotation variableAnnotation = ValueNumberSourceInfo.findAnnotationFromValueNumber(this.getMethod(), produced, value, valueNumberFact, "VALUE_OF");
                    Set<Location> unconditionalDerefLocationSet = unconditionalDeref.getUnconditionalDerefLocationSet(value);
                    if (unconditionalDerefLocationSet.size() > 1) {
                        bug = new BugInstance(this, "NP_GUARANTEED_DEREF", 2).addClassAndMethod(this);
                        bug.addOptionalAnnotation(variableAnnotation);
                        bug.addSourceLine(tested).describe("SOURCE_LINE_KNOWN_NULL");
                        for (Location dereferenced : unconditionalDerefLocationSet) {
                            bug.addSourceLine(this.getClassContext(), this.getMethod(), dereferenced).describe("SOURCE_LINE_DEREF");
                        }
                    } else {
                        bug = new BugInstance(this, "NP_NULL_ON_SOME_PATH", 2).addClassAndMethod(this);
                        bug.addOptionalAnnotation(variableAnnotation);
                        for (Location dereferenced : unconditionalDerefLocationSet) {
                            bug.addSourceLine(this.getClassContext(), this.getMethod(), dereferenced).describe("SOURCE_LINE_DEREF");
                        }
                        bug.addSourceLine(tested).describe("SOURCE_LINE_KNOWN_NULL");
                    }
                    this.bugReporter.reportBug(bug);
                }
            }
            catch (DataflowAnalysisException e) {
                this.bugReporter.logError("Error getting analysis for " + this.getFullyQualifiedMethodName(), e);
            }
            catch (CFGBuilderException e) {
                this.bugReporter.logError("Error getting analysis for " + this.getFullyQualifiedMethodName(), e);
            }
        }
    }

    @CheckForNull
    Location findLocation(CFG cfg, int pc) {
        Iterator<Location> i = cfg.locationIterator();
        while (i.hasNext()) {
            Location loc = i.next();
            if (loc.getHandle().getPosition() != pc) continue;
            return loc;
        }
        return null;
    }

    @CheckForNull
    Location findLocation(CFG cfg, InstructionHandle handle) {
        Iterator<Location> i = cfg.locationIterator();
        while (i.hasNext()) {
            Location loc = i.next();
            if (loc.getHandle() != handle) continue;
            return loc;
        }
        return null;
    }

    private boolean nullGuaranteesBranch(int seen, OpcodeStack.Item item) {
        return item.getSpecialKind() == 17 && seen == 126 || item.getSpecialKind() == 18 && seen == 128;
    }

    private void emitWarning() {
        System.out.println("Warn about " + this.getMethodName());
    }
}

